% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edges.R
\name{IEdge2}
\alias{IEdge2}
\title{R6 class representing a semi-infinite edge in dimension 2}
\description{
A semi-infinite edge is given by a vertex, its origin,
  and a vector, its direction. Voronoï diagrams possibly have such edges.
}
\examples{

## ------------------------------------------------
## Method `IEdge2$new`
## ------------------------------------------------

iedge <- IEdge2$new(c(1, 1), c(2, 3))
iedge
iedge$O
iedge$O <- c(1, 0)
iedge

## ------------------------------------------------
## Method `IEdge2$print`
## ------------------------------------------------

IEdge2$new(c(2, 0), c(3, -1))
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{O}}{get or set the vertex \code{O}}

\item{\code{direction}}{get or set the vector \code{direction}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IEdge2-new}{\code{IEdge2$new()}}
\item \href{#method-IEdge2-print}{\code{IEdge2$print()}}
\item \href{#method-IEdge2-clone}{\code{IEdge2$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IEdge2-new"></a>}}
\if{latex}{\out{\hypertarget{method-IEdge2-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{IEdge2} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IEdge2$new(O, direction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{O}}{the vertex \code{O} (origin)}

\item{\code{direction}}{the vector \code{direction}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{IEdge2} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{iedge <- IEdge2$new(c(1, 1), c(2, 3))
iedge
iedge$O
iedge$O <- c(1, 0)
iedge
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IEdge2-print"></a>}}
\if{latex}{\out{\hypertarget{method-IEdge2-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{IEdge2} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IEdge2$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{IEdge2$new(c(2, 0), c(3, -1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IEdge2-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IEdge2-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IEdge2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
