% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{getDelaunaySimplices}
\alias{getDelaunaySimplices}
\alias{getDelaunaySimplicies}
\title{Delaunay simplices}
\usage{
getDelaunaySimplices(tessellation, hashes = FALSE)

getDelaunaySimplicies(tessellation, hashes = FALSE)
}
\arguments{
\item{tessellation}{the output of \code{\link{delaunay}}}

\item{hashes}{Boolean, whether to return the simplices as hash maps}
}
\value{
The list of simplices of the Delaunay tessellation.
}
\description{
Get Delaunay simplices (tiles).
}
\examples{
library(tessellation)
pts <- rbind(
  c(-5, -5,  16),
  c(-5,  8,   3),
  c(4,  -1,   3),
  c(4,  -5,   7),
  c(4,  -1, -10),
  c(4,  -5, -10),
  c(-5,  8, -10),
  c(-5, -5, -10)
)
tess <- delaunay(pts)
getDelaunaySimplices(tess)
}
