% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cfpr}
\alias{cfpr}
\title{US Cystic Fibrosis Patient Registry data}
\format{
A data frame with 11,960 rows and 3 columns:
\describe{
  \item{pulm.exac}{Presence or absence of previous pulmonary exacerbation.}
  \item{pseudomonas}{Presence or absence of Pseudomonas aeruginosa
  infection.}
  \item{infection}{Presence or absence of severe infection (gold standard).}
}
}
\source{
Data was sourced directly from the referenced paper. For up-to-date data
requests contact:
\href{https://www.cff.org/researchers/patient-registry-data-requests}{Cystic Fibrosis Foundation}
}
\usage{
cfpr
}
\description{
This data from the Cystic Fibrosis Foundation's Patient Registry (USA)
evaluates risk factors for pulmonary exacerbation in patients with cystic
fibrosis. The two risk factors evaluated are previous pulmonary exacerbation
and previous colonisation with Pseudomonas aeruginosa.
Each of the two risk factors was evaluated using data from 1995. If an
instance occurred at any point in 1995 the 'test' was considered positive.
If negative throughout 1995 the 'test' was considered negative. The gold
standard was evidence of pulmonary exacerbation at any point in 1996.
}
\details{
All three variables are dichotomous. 1 indicates presence; 0 indicates
absence.

This data was originally presented in Moskowitz and Pepe (2006).
}
\references{
Moskowitz and Pepe (2006) Clinical Trials. 2006;3(3):272-9.
\doi{10.1191/1740774506cn147oa}
}
\keyword{datasets}
