% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal3var.R
\name{equa3vartest}
\alias{equa3vartest}
\title{Bootstrap test for equality of three (3) population variances}
\usage{
equa3vartest(x1, x2, x3, a, B)
}
\arguments{
\item{x1}{first sample vector of data or observations}

\item{x2}{second sample vector of data or observations}

\item{x3}{third sample vector of data or observations}

\item{a}{significance level alpha}

\item{B}{number of bootstrap samples. At least 500 is recommended.}
}
\value{
list consisting of a non-numeric decision whether to reject the null hypothesis or not, the significance level, and the number of bootstrap samples used
}
\description{
Testing equality of three (3) population variances against the alternative that all variances are  unequal.
}
\examples{


x1=sqrt(10)*runif(10, -sqrt(3), sqrt(3) )
x2=sqrt(1)*runif(10, -sqrt(3), sqrt(3) )
x3=sqrt(1)*runif(10, -sqrt(3), sqrt(3) )
equa3vartest(x1,x2,x3, a=0.05, B=500)


equa3vartest( rexp(10) ,rexp(10) ,rexp(10) ,  a=0.01, B=1000)


}
\references{
Cahoy, DO (2010), \emph{A Bootstrap Test For Equality Of Variances,} Computational Statistics & Data Analysis, 54(10), 2306-2316.
\doi{10.1016/j.csda.2010.04.012}
}
