% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-equality.R
\name{expect_reference}
\alias{expect_reference}
\title{Does code return a reference to the expected object?}
\usage{
expect_reference(
  object,
  expected,
  info = NULL,
  label = NULL,
  expected.label = NULL
)
}
\arguments{
\item{object}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert
use only.}

\item{expected.label}{Used to customise failure messages. For expert
use only.}
}
\description{
\code{expect_reference()} compares the underlying memory addresses of
two symbols. It is for expert use only.
}
\section{3rd edition}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{expect_reference()} is deprecated in the third edition. If you know what
you're doing, and you really need this behaviour, just use \code{is_reference()}
directly: \code{expect_true(rlang::is_reference(x, y))}.
}

\seealso{
Other expectations: 
\code{\link{comparison-expectations}},
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_length}()},
\code{\link{expect_match}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_silent}()},
\code{\link{inheritance-expectations}},
\code{\link{logical-expectations}}
}
\concept{expectations}
\keyword{internal}
