% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmSim.R
\name{evmSim}
\alias{evmSim}
\title{MCMC simulation around an evmOpt fit}
\usage{
evmSim(
  o,
  priorParameters,
  prop.dist,
  jump.const,
  jump.cov,
  iter,
  start,
  thin,
  burn,
  chains,
  export = NULL,
  verbose,
  trace,
  theCall,
  ...
)
}
\arguments{
\item{o}{a fit \code{evmOpt} object}

\item{priorParameters}{A list with two components. The first should
be a vector of means, the second should be a covariance matrix
if the penalty/prior is "gaussian" or "quadratic" and a
diagonal precision matrix if the penalty/prior is "lasso", "L1"
or "Laplace".  If \code{method = "simulate"} then these
represent the parameters in the Gaussian prior distribution.
If \code{method = 'optimize'} then these represent the
parameters in the penalty function.  If not supplied: all
default prior means are zero; all default prior variances are
\eqn{10^4}; all covariances are zero.}

\item{prop.dist}{The proposal distribution to use, either
multivariate gaussian or a multivariate Cauchy.}

\item{jump.const}{Control parameter for the Metropolis algorithm.}

\item{jump.cov}{Covariance matrix for proposal distribution of
Metropolis algorithm.  This is scaled by \code{jump.const}.}

\item{iter}{Number of simulations to generate}

\item{start}{Starting values for the chain; if missing, defaults to
the MAP/ML estimates in \code{o}.}

\item{thin}{The degree of thinning of the resulting Markov chains.}

\item{burn}{The number of initial steps to be discarded.}

\item{chains}{The number of Markov chains to run. Defaults to 1. If you run
more, the function will try to figure out how to do it in parallel using
the same number of cores as chains.}

\item{export}{Character vector of names of variables to export. See the
help file for \code{parallel::export}. Defaults to \code{export = NULL}
and most users will never need to use it. Only matters on Windows.}

\item{verbose}{Whether or not to print progress to screen. Defaults
to \code{verbose=TRUE}.}

\item{trace}{How frequently to talk to the user}

\item{theCall}{(internal use only)}

\item{...}{ignored}
}
\value{
an object of class \code{evmSim}:

\item{call}{The call to \code{evmSim} that produced the object.}

\item{threshold}{The threshold above which the model was fit.}

\item{map}{The point estimates found by maximum penalized
likelihood and which were used as the starting point for the Markov
chain.  This is of class \code{evmOpt} and methods for this class
(such as resid and plot) may be useful.}

\item{burn}{The number of steps of the Markov chain that are to be
treated as the burn-in and not used in inferences.}

\item{thin}{The degree of thinning used.}

\item{chains}{The entire Markov chain generated by the Metropolis
algorithm.}

\item{y}{The response data above the threshold for
fitting.}

\item{seed}{The seed used by the random number generator.}

\item{param}{The remainder of the chain after deleting
the burn-in and applying any thinning.}
}
\description{
MCMC simulation around an evmOpt fit
}
\note{
it is not expected that the user should call this directly
}
