% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tikz-tools.R
\name{article_has_tikz}
\alias{article_has_tikz}
\title{Check if article has tikz images or not}
\usage{
article_has_tikz(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
TRUE if tikz image is present else FALSE
}
\description{
This simple utiliy function will check for tikzpicture environment
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::article_has_tikz(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
