% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,bam-method}
\alias{extract,bam-method}
\alias{extract.bam}
\title{\code{\link{extract}} method for \code{bam} objects}
\usage{
\S4method{extract}{bam}(
  model,
  include.smooth = TRUE,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.deviance = TRUE,
  include.dev.expl = TRUE,
  include.dispersion = TRUE,
  include.rsquared = TRUE,
  include.gcv = TRUE,
  include.nobs = TRUE,
  include.nsmooth = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.smooth}{Report the smooth terms of a GAM? If they are
reported, the EDF value is reported as the coefficient, and DF is included
in parentheses (not standard errors because a chi-square test is used for
the smooth terms).}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.deviance}{Report the deviance?}

\item{include.dev.expl}{Report the deviance explained?}

\item{include.dispersion}{Report the dispersion parameter?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.gcv}{Report the GCV score?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.nsmooth}{Report the number of smooth terms?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{bam} objects created by the
\code{\link[mgcv]{bam}} function in the \pkg{mgcv} package.
}
