% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\docType{class}
\name{texreg-class}
\alias{texreg-class}
\title{An S4 class to represent a statistical model as a texreg object}
\description{
An S4 class to represent a statistical model as a texreg object.
}
\details{
A \linkS4class{texreg} object stores details about a statistical model. It
can be used for creating regression tables using \code{\link{screenreg}},
\code{\link{texreg}}, and similar functions.
}
\section{Slots}{

\describe{
\item{\code{coef.names}}{The covariate names.}

\item{\code{coef}}{The coefficients.}

\item{\code{se}}{The standard errors.}

\item{\code{pvalues}}{The p-values.}

\item{\code{ci.low}}{The lower bounds of the confidence intervals.}

\item{\code{ci.up}}{The upper bounds of the confidence intervals.}

\item{\code{gof.names}}{The names of the goodness-of-fit statistics.}

\item{\code{gof}}{The goodness-of-fit statistics.}

\item{\code{gof.decimal}}{A vector describing for each GOF statistic whether it is a
decimal value (\code{TRUE}) or an integer value (\code{FALSE}).}

\item{\code{model.name}}{An optional model name. Can be of length zero.}
}}

\references{
Leifeld, Philip (2013). texreg: Conversion of Statistical Model
  Output in R to LaTeX and HTML Tables. Journal of Statistical Software
  55(8): 1-24. \doi{10.18637/jss.v055.i08}.
}
\seealso{
\code{\link{extract}} \code{\link{createTexreg}}
}
\author{
Philip Leifeld
}
