% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_2_textSimilarityTest.R
\name{textSimilarityTest}
\alias{textSimilarityTest}
\title{Test whether there is a significant difference in meaning between two sets of texts
(i.e., between their word embeddings).}
\usage{
textSimilarityTest(
  x,
  y,
  Npermutations = 10000,
  method = "paired",
  alternative = c("two_sided", "less", "greater"),
  output.permutations = TRUE,
  N_cluster_nodes = 1,
  seed = 1001
)
}
\arguments{
\item{x}{Set of word embeddings from textEmbed.}

\item{y}{Set of word embeddings from textEmbed.}

\item{Npermutations}{Number of permutations (default 1000).}

\item{method}{Compute a "paired" or an "unpaired" test.}

\item{alternative}{Use a two or one-sided test (select one of: "two_sided", "less", "greater").}

\item{output.permutations}{If TRUE, returns permuted values in output.}

\item{N_cluster_nodes}{Number of cluster nodes to use (more makes computation faster; see parallel package).}

\item{seed}{Set different seed.}
}
\value{
A list with a p-value, cosine_estimate and permuted values if output.permutations=TRUE.
}
\description{
Test whether there is a significant difference in meaning between two sets of texts
(i.e., between their word embeddings).
}
\examples{
x <- wordembeddings4$harmonywords
y <- wordembeddings4$satisfactionwords
textSimilarityTest(x,
  y,
  method = "paired",
  Npermutations = 10,
  N_cluster_nodes = 1,
  alternative = "two_sided"
)
}
