% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textSimilarityMatrix}
\alias{textSimilarityMatrix}
\title{Compute semantic similarity scores between all combinations in a word embedding}
\usage{
textSimilarityMatrix(x, method = "cosine")
}
\arguments{
\item{x}{Word embeddings from textEmbed.}

\item{method}{Character string describing type of measure to be computed. Default is "cosine" (see also
measures from textDistance() (which here is computed as 1 - textDistance) including "euclidean", "maximum",
"manhattan", "canberra", "binary" and "minkowski").}
}
\value{
A matrix of semantic similarity scores
}
\description{
Compute semantic similarity scores between all combinations in a word embedding
}
\examples{
similarity_scores <- textSimilarityMatrix(word_embeddings_4$harmonytext[1:3, ])
round(similarity_scores, 3)
}
\seealso{
see \code{\link{textSimilarityNorm}} and \code{\link{textSimilarityTest}}
}
