% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dtm.R
\name{dtm_stopper}
\alias{dtm_stopper}
\title{Removes terms from a DTM based on rules}
\usage{
dtm_stopper(dtm, stop_list = NULL, stop_freq = NULL, ignore_case = TRUE)
}
\arguments{
\item{dtm}{Document-term matrix with words as columns. Works with DTMs
produced by any popular text analysis package, or you can use the
\code{dtm_builder()} function.}

\item{stop_list}{Vector of terms, from either a precompiled stoplist or
custom list such as \code{c("never", "gonna", "give")}, or a
combination of the two.}

\item{stop_freq}{Vector of two numbers indicating the lower and upper
threshold for inclusion. If real numbers less than 1,
for example \code{c(0.01, 0.99)}, then words will be removed by
proportion, here words in more than 99\% of all documents or
words that are in less than 1\% of all documents. If
integers are provided, for example \code{c(100, 9000)}, then
words will be removed by count, here words occurring less
than 100 or more than 9000 times  in the corpus will
be removed.}

\item{ignore_case}{Logical (default = TRUE) indicating whether to ignore
capitalization when matching.}
}
\value{
returns a document-term matrix of class "dgCMatrix"
}
\description{
\code{dtm_stopper()} will "stop" terms from the analysis by removing columns
that match terms to be stopped. Rules include using precompiled or custom
list of terms, or terms meeting an upper or lower document frequency
threshold.
}
\details{
Stopping terms by removing their respective columns in the DTM is
significantly more efficient than searching raw text with string matching
and deletion rules. The \code{stop_freq} and \code{stop_list} arguments are akin to
the \code{tm} package's \code{removeSparseTerms} and \code{removeWords} functions,
respectively. Behind the scenes, the function relies on the \code{fastmatch}
package to quickly match/not-match terms.
}
\author{
Dustin Stoltz
}
