% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dtm.R
\name{dtm_melter}
\alias{dtm_melter}
\title{Melt a DTM into a triplet data frame}
\usage{
dtm_melter(dtm)
}
\arguments{
\item{dtm}{Document-term matrix with terms as columns. Works with DTMs
produced by any popular text analysis package, or using the
\code{dtm_builder()} function.}
}
\value{
returns data frame with three columns: doc_id, term, freq
}
\description{
Converts a DTM into a data frame with three columns:
documents, terms, frequency. Each row is a unique
document by term frequency. This is akin to \code{reshape2}
packages \code{melt} function, but works on a sparse matrix.
The resulting data frame is also equivalent to the
\code{tidytext} triplet tibble.
}
\author{
Dustin Stoltz
}
