% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{create_vocab_corpus}
\alias{create_hash_corpus}
\alias{create_vocab_corpus}
\title{RAM-friendly streaming corpus construction.}
\usage{
create_vocab_corpus(iterator, vocabulary, grow_dtm = TRUE,
  skip_grams_window = 0L)

create_hash_corpus(iterator, feature_hasher = feature_hasher(),
  grow_dtm = TRUE, skip_grams_window = 0)
}
\arguments{
\item{iterator}{iterator over \code{list} of \code{character} vectors.
Each element is a list of tokens = tokenized and normalized strings.}

\item{vocabulary}{\code{text2vec_vocabulary} object, see \link{vocabulary}.}

\item{grow_dtm}{\code{logical} should we grow Document-Term matrix
during corpus construction or not.}

\item{skip_grams_window}{\code{integer} window for Term-Cooccurence matrix
construction. 0L points to do not construct such matrix.}

\item{feature_hasher}{\code{text2vec_feature_hasher} object, which contains meta information
about feature hashing. See \link{feature_hasher} for details.}
}
\value{
corpus object,
We can add documents into this corpus by reference - no copy at all.
See source code for details.
For full process example see \link{get_dtm}.
}
\description{
This functions allow to create corpus objects (vocabulary or hash based),
which are stored outside of R's heap and wrapped via Reference Classes using Rcpp-Modules.
From that objects you can easily extract Document-Term (dtm) and Term-Cooccurnce(tcm)
matrices. Also text2vec grows corpus for \code{tcm} and \code{dtm} simultaneously in a very
ram-friendly and efficient way using iterators abstraction. So you can build corpuses from
objects/files which are orders of magnitude larger that available RAM.
}
\seealso{
\link{feature_hasher}.
}

