% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{split_vector}
\alias{split_vector}
\title{Generating indexes for splitting vector into chunks}
\usage{
split_vector(vector, splits, granularity = 1)
}
\arguments{
\item{vector}{\link{list} or \link{vector} to split}

\item{splits}{\link{integer} - controls number of parallel jobs you have planned.
Usually should be equal to number of cores in the machine.}

\item{granularity}{\link{integer} -  granularity is useful for management of granularity
of splits. If you expect that computational time on each chunk of your data will
be distributed nerarly uniformly, granularity = 1 is good choice because of little overheads
in syncronizing parallel processes.}
}
\value{
\link{list} each element is a \link{integer} \link{vector} pair.
First element in pair is lower index, second element is upper index.
}
\description{
Generating indexes for splitting vector into chunks for parallel processing.
}
\details{
Parameters granularity and splits controls the numer of chunks in returned list.
Number of chunks in resulted list in general is equal granularity * splits
}

