% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm.R
\name{get_dtm}
\alias{get_dtm}
\title{Extract document-term matrix}
\usage{
get_dtm(corpus, type = c("dgCMatrix", "dgTMatrix", "lda_c"))
}
\arguments{
\item{corpus}{\code{HashCorpus} or \code{VocabCorpus} object. See
\link{create_corpus} for details.}

\item{type}{character, one of \code{c("dgCMatrix", "dgTMatrix", "lda_c")}.
\code{"lda_c"} is Blei's lda-c format (a list of 2 * doc_terms_size); see
\url{https://www.cs.princeton.edu/~blei/lda-c/readme.txt}}
}
\description{
This function extracts a document-term matrix from a
  \code{Corpus} object.
}
\examples{
N <- 1000
tokens <- movie_review$review[1:N] \%>\% tolower \%>\% word_tokenizer
it <- itoken(tokens)
v <- create_vocabulary(it)

#remove very common and uncommon words
pruned_vocab = prune_vocabulary(v, term_count_min = 10,
 doc_proportion_max = 0.8, doc_proportion_min = 0.001,
 max_number_of_terms = 10000)

vectorizer <- vocab_vectorizer(v)
it <- itoken(tokens)
corpus <- create_corpus(it, vectorizer)
dtm <- get_dtm(corpus)
}

