% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_bing.R
\name{lexicon_bing}
\alias{lexicon_bing}
\title{Bing sentiment lexicon}
\source{
\url{https://www.cs.uic.edu/~liub/FBS/sentiment-analysis.html}
}
\usage{
lexicon_bing(dir = NULL, delete = FALSE, return_path = FALSE)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}
}
\value{
A tibble with 6,787 rows and 2 variables:
\describe{
  \item{word}{An English word}
  \item{sentiment}{Indicator for sentiment: "negative" or "positive"}
}
}
\description{
General purpose English sentiment lexicon that categorizes words in a
binary fashion, either positive or negative
}
\details{
Citation info:

This dataset was first published in Minqing Hu and Bing Liu, ``Mining and
summarizing customer reviews.'', Proceedings of the ACM SIGKDD International
Conference on Knowledge Discovery & Data Mining (KDD-2004), 2004.

inproceedings\{Hu04, \cr
author    = \{Hu, Minqing and Liu, Bing\}, \cr
title     = \{Mining and Summarizing Customer Reviews\}, \cr
booktitle = \{Proceedings of the Tenth ACM SIGKDD International Conference
              on Knowledge Discovery and Data Mining\}, \cr
series    = \{KDD '04\}, \cr
year      = \{2004\}, \cr
isbn      = \{1-58113-888-1\}, \cr
location  = \{Seattle, WA, USA\}, \cr
pages     = \{168--177\}, \cr
numpages  = \{10\}, \cr
url       = \{http://doi.acm.org/10.1145/1014052.1014073\}, \cr
doi       = \{10.1145/1014052.1014073\}, \cr
acmid     = \{1014073\}, \cr
publisher = \{ACM\}, \cr
address   = \{New York, NY, USA\}, \cr
keywords  = \{reviews, sentiment classification, summarization, text mining\}, \cr
\}
}
\examples{
\donttest{
lexicon_bing()

# Custom directory
lexicon_bing(dir = "data/")

# Deleting dataset
lexicon_bing(delete = TRUE)

# Returning filepath of data
lexicon_bing(return_path = TRUE)
}
}
\keyword{datasets}
