% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_count}
\alias{scale_count}
\alias{scale_log}
\alias{scale_normal}
\alias{scale_standard}
\alias{scale_sqrt}
\title{Apply various transformations to numeric (and non-id) data}
\usage{
scale_count(x)

scale_log(x)

scale_normal(x)

scale_standard(x)

scale_sqrt(x)
}
\arguments{
\item{x}{Input data frame containing numeric columns.}
}
\value{
A data frame with the same dimensions but with the
  numeric/relevant variables transformed.
}
\description{
scale_count: Transforms integer and integerlike columns using log

scale_log: Transforms numeric columns using log

scale_normal: Transforms numeric columns using mean centering and dividing by standard deviation

scale_standard: Transforms numeric columns onto 0-1 scales with 0 and 1 set empirically

scale_sqrt: Transforms numeric columns using sqrt
}
\details{
Scale transformations are applied only to numeric (or in the
  case of \code{scale_count} only integer or integerish) columns
  that are not named \code{"id"} or \code{"(\\.|_)?id"}.
}
