% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_utilities.R
\name{TmParallelApply}
\alias{TmParallelApply}
\title{An OS-independent parallel version of \code{\link[base]{lapply}}}
\usage{
TmParallelApply(X, FUN, cpus = parallel::detectCores(), export = NULL,
  libraries = NULL, envir = parent.frame())
}
\arguments{
\item{X}{A vector or list over which to apply \code{FUN}}

\item{FUN}{A function to apply over \code{X}}

\item{cpus}{Number of CPU cores to use, defaults to the value returned by 
\code{\link[parallel]{detectCores}}.}

\item{export}{A character vector of objects in the workspace to export when 
using a Windows machine. Defaults to \code{NULL}}

\item{libraries}{A character vector of library/package names to load on to
each cluster if using a Windows machine. Defaults to \code{NULL}}

\item{envir}{Environment from which to export variables in varlist}
}
\value{
This function returns a \code{list} of length \code{length(X)}.
}
\description{
This function takes a vector or list and a function and applies in parallel.
}
\details{
This function is used to parallelize executions in \code{textmineR}. It is 
necessary because of differing capabilities between Windows and Unix.
Unix systems use \code{\link[parallel]{mclapply}}. Windows 
systems use \code{\link[parallel]{parLapply}}.
}
\examples{
\dontrun{
x <- 1:10000
f <- function(y) y * y + 12
result <- TmParallelApply(x, f)
}
}
