% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenlist.R
\name{tokenlist}
\alias{tokenlist}
\title{Create tokenlist object}
\usage{
tokenlist(tokens = list(), lemma = NULL, pos = NULL)
}
\arguments{
\item{tokens}{List of character vectors}

\item{lemma}{List of character vectors, must be same size and shape as \code{x}.}

\item{pos}{List of character vectors, must be same size and shape as \code{x}.}
}
\value{
a \link{tokenlist} object.
}
\description{
A \link{tokenlist} object is a thin wrapper around a list of character vectors,
with a few attributes.
}
\examples{
abc <- list(letters, LETTERS)
tokenlist(abc)

unclass(tokenlist(abc))

tibble(text = tokenlist(abc))

library(tokenizers)
library(modeldata)
data(okc_text)
tokens <- tokenize_words(okc_text$essay0)

tokenlist(tokens)
}
