% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_levels.R
\name{step_clean_levels}
\alias{step_clean_levels}
\alias{tidy.step_clean_levels}
\title{Clean categorical levels}
\usage{
step_clean_levels(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  clean = NULL,
  skip = FALSE,
  id = rand_id("clean_levels")
)

\method{tidy}{step_clean_levels}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables' levels will be cleaned. See \code{\link[recipes:selections]{recipes::selections()}} for more
details. For the \code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{clean}{A named character vector to clean and recode categorical levels.
This is \code{NULL} until computed by \code{\link[recipes:prep]{recipes::prep.recipe()}}. Note that if the
original variable is a character vector, it will be converted to a factor.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all
operations are baked when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using \code{skip = TRUE} as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_clean_levels} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the \code{tidy} method, a
tibble with columns \code{terms} (the columns that are cleaned), \code{original} (the
original uncleaned levels) and \code{value} (the new cleaned levels).
}
\description{
\code{step_clean_levels} creates a \emph{specification} of a recipe step that will
clean nominal data (character or factor) so the levels consist only of
letters, numbers, and the underscore.
}
\details{
The new levels are cleaned and then reset with
\code{\link[dplyr:recode]{dplyr::recode_factor()}}. When data to be processed contains novel
levels (i.e., not contained in the training set), they are converted
to missing.
}
\examples{
library(recipes)
library(modeldata)
data(Smithsonian)

smith_tr <- Smithsonian[1:15, ]
smith_te <- Smithsonian[16:20, ]

rec <- recipe(~., data = smith_tr)

if (requireNamespace("janitor", quietly = TRUE)) {
  rec <- rec \%>\%
    step_clean_levels(name)
  rec <- prep(rec, training = smith_tr)

  cleaned <- bake(rec, smith_tr)

  tidy(rec, number = 1)

  # novel levels are replaced with missing
  bake(rec, smith_te)
}
}
\seealso{
\code{\link[=step_clean_names]{step_clean_names()}}, \code{\link[recipes:step_factor2string]{recipes::step_factor2string()}},
\code{\link[recipes:step_string2factor]{recipes::step_string2factor()}}, \code{\link[recipes:step_regex]{recipes::step_regex()}},
\code{\link[recipes:step_unknown]{recipes::step_unknown()}}, \code{\link[recipes:step_novel]{recipes::step_novel()}}, \code{\link[recipes:step_other]{recipes::step_other()}}
}
