% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopwords.R
\name{step_stopwords}
\alias{step_stopwords}
\title{Filtering of Stop Words for Tokens Variables}
\usage{
step_stopwords(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  language = "en",
  keep = FALSE,
  stopword_source = "snowball",
  custom_stopword_source = NULL,
  skip = FALSE,
  id = rand_id("stopwords")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{language}{A character to indicate the language of stop words by ISO
639-1 coding scheme.}

\item{keep}{A logical. Specifies whether to keep the stop words or discard
them.}

\item{stopword_source}{A character to indicate the stop words source as
listed in \code{stopwords::stopwords_getsources}.}

\item{custom_stopword_source}{A character vector to indicate a custom list of
words that cater to the users specific problem.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_stopwords()} creates a \emph{specification} of a recipe step that will
filter a \code{\link[=tokenlist]{token}} variable for stop words.
}
\details{
Stop words are words which sometimes are remove before natural language
processing tasks. While stop words usually refers to the most common words in
the language there is no universal stop word list.

The argument \code{custom_stopword_source} allows you to pass a character vector
to filter against. With the \code{keep} argument one can specify to keep the words
instead of removing thus allowing you to select words with a combination of
these two arguments.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} (name of stop word list), and
\code{keep} (whether stop words are removed or kept).
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("stopwords")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(modeldata)
data(tate_text)
tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_stopwords(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL, medium) \%>\%
  slice(1:2)

bake(tate_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(medium)

tidy(tate_rec, number = 2)
tidy(tate_obj, number = 2)

# With a custom stop words list

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_stopwords(medium, custom_stopword_source = c("twice", "upon"))
tate_obj <- tate_rec \%>\%
  prep(traimomg = tate_text)

bake(tate_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(medium)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}

Other Steps for Token Modification: 
\code{\link{step_lemma}()},
\code{\link{step_ngram}()},
\code{\link{step_pos_filter}()},
\code{\link{step_stem}()},
\code{\link{step_tokenfilter}()},
\code{\link{step_tokenmerge}()}
}
\concept{Steps for Token Modification}
