% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.R
\name{step_lda}
\alias{step_lda}
\title{Calculate LDA Dimension Estimates of Tokens}
\source{
\url{https://arxiv.org/abs/1301.3781}
}
\usage{
step_lda(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  lda_models = NULL,
  num_topics = 10L,
  prefix = "lda",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("lda")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{lda_models}{A WarpLDA model object from the text2vec package. If left
to NULL, the default, will it train its model based on the training data.
Look at the examples for how to fit a WarpLDA model.}

\item{num_topics}{integer desired number of latent topics.}

\item{prefix}{A prefix for generated column names, default to "lda".}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_lda()} creates a \emph{specification} of a recipe step that will return the
lda dimension estimates of a text variable.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected) and \code{num_topics} (number of topics).
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (all(c("text2vec", "data.table") \%in\% rownames(installed.packages()))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{library(data.table)}
\dontshow{data.table::setDTthreads(2)}
\dontshow{Sys.setenv("OMP_THREAD_LIMIT" = 2)}
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_lda(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL) \%>\%
  slice(1:2)
tidy(tate_rec, number = 2)
tidy(tate_obj, number = 2)

# Changing the number of topics.
recipe(~., data = tate_text) \%>\%
  step_tokenize(medium, artist) \%>\%
  step_lda(medium, artist, num_topics = 20) \%>\%
  prep() \%>\%
  bake(new_data = NULL) \%>\%
  slice(1:2)

# Supplying A pre-trained LDA model trained using text2vec
library(text2vec)
tokens <- word_tokenizer(tolower(tate_text$medium))
it <- itoken(tokens, ids = seq_along(tate_text$medium))
v <- create_vocabulary(it)
dtm <- create_dtm(it, vocab_vectorizer(v))
lda_model <- LDA$new(n_topics = 15)

recipe(~., data = tate_text) \%>\%
  step_tokenize(medium, artist) \%>\%
  step_lda(medium, artist, lda_models = lda_model) \%>\%
  prep() \%>\%
  bake(new_data = NULL) \%>\%
  slice(1:2)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Steps for Numeric Variables From Tokens: 
\code{\link{step_texthash}()},
\code{\link{step_tfidf}()},
\code{\link{step_tf}()},
\code{\link{step_word_embeddings}()}
}
\concept{Steps for Numeric Variables From Tokens}
