% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_word_lists.R
\name{list.table.chart}
\alias{list.table.chart}
\title{Graphic showing multiple word lists side-by-side.}
\usage{
list.table.chart(model.list, M = 100, linespace = 4, ytick = NULL,
  dates = NULL, main = paste("Word Appearance for ", attr(model.list,
  "topic"), "\\n(Method: ", attr(model.list, "method"), ")", sep = ""),
  xlab = "Model", mar = c(3, 5, 2.5, 0.1), xaxt = "y",
  color.breaks = NULL, color.ramp = NULL, ...)
}
\arguments{
\item{model.list}{Matrix (or data.frame) from the make.list.table call.}

\item{M}{is the max number of words to show in chart}

\item{linespace}{Where to space}

\item{ytick}{Put y tick marks}

\item{dates}{Dates to put on bottom}

\item{main}{Main title}

\item{xlab}{Label for x-axis}

\item{mar}{Margin of plot (see par)}

\item{xaxt}{Plot an x-axis (see par)}

\item{color.breaks}{Cut-points (like on a histogram) defining the different color levels.}

\item{color.ramp}{List of colors to use from lowest value (potentially negative weights) to highest.  If both color.breaks and color.ramp passed, color.breaks is list one longer than color.ramp.}

\item{...}{Extra arguments for the core image() call that plots the word weights.}
}
\description{
This method basically makes a visual plot of a list table (which you call first).
}
\seealso{
make.list.table
}
