% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_colo_dtm.R
\name{tidy_colo_tdm}
\alias{tidy_colo_dtm}
\alias{tidy_colo_tdm}
\title{Convert a \code{\link[tm]{DocumentTermMatrix}}/\code{\link[tm]{TermDocumentMatrix}} into Collocating Words in Tidy Form}
\usage{
tidy_colo_tdm(x, as.tibble = tibble_output(), ...)

tidy_colo_dtm(x, as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A \code{\link[tm]{DocumentTermMatrix}}/\code{\link[tm]{TermDocumentMatrix}}.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a tidied data.frame.
}
\description{
Converts non-zero elements of a
\code{\link[tm]{DocumentTermMatrix}}/\code{\link[tm]{TermDocumentMatrix}} into
a tidy data set made of collocating words.
}
\examples{
data(simple_dtm)

tidied <- tidy_colo_dtm(simple_dtm)
tidied
unique_pairs(tidied)

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load_current_gh('trinker/gofastr', 'trinker/lexicon')
pacman::p_load(tidyverse, magrittr, ggstance)

my_dtm <- with(presidential_debates_2012, q_dtm(dialogue, paste(time, tot, sep = "_")))

tidy_colo_dtm(my_dtm) \%>\%
    tbl_df() \%>\%
    filter(!term_1 \%in\% c('i', lexicon::sw_onix) & !term_2 \%in\% lexicon::sw_onix) \%>\%
    filter(term_1 != term_2) \%>\%
    unique_pairs() \%>\%
    filter(n > 15) \%>\%
    complete(term_1, term_2, fill = list(n = 0)) \%>\%
    ggplot(aes(x = term_1, y = term_2, fill = n)) +
        geom_tile() +
        scale_fill_gradient(low= 'white', high = 'red') +
        theme(axis.text.x = element_text(angle = 45, hjust = 1))
}
}
\seealso{
\code{\link[textshape]{unique_pairs}}
}

