% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{predict.um}
\alias{predict.um}
\title{Forecasts from an ARIMA model}
\usage{
\method{predict}{um}(object, z = NULL, ori = NULL, n.ahead = 1, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{\link{um}}.}

\item{z}{an object of class \code{\link{ts}}.}

\item{ori}{the origin of prediction. By default, it is the last observation.}

\item{n.ahead}{number of steps ahead.}

\item{level}{confidence level.}

\item{...}{additional arguments.}
}
\value{
An object of class "\code{\link{tfm}}".
}
\description{
\code{predict} computes point and interval predictions for a time series 
from models of class  \code{\link{um}}.
}
\examples{
Z <- AirPassengers
um1 <- um(Z, i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
p <- predict(um1, n.ahead = 12)
p
plot(p, n.back = 60)

}
