% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_graph.R
\name{predict_savedmodel.graph_prediction}
\alias{predict_savedmodel.graph_prediction}
\title{Predict using a Loaded SavedModel}
\usage{
\method{predict_savedmodel}{graph_prediction}(instances, model, sess,
  signature_name = "serving_default", ...)
}
\arguments{
\item{instances}{A list of prediction instances to be passed as input tensors
to the service. Even for single predictions, a list with one entry is expected.}

\item{model}{The model as a local path, a REST url or graph object.

A local path can be exported using \code{export_savedmodel()}, a REST URL
can be created using \code{serve_savedmodel()} and a graph object loaded using
\code{load_savedmodel()}.

A \code{type} parameter can be specified to explicitly choose the type model
performing the prediction. Valid values are \code{export}, \code{webapi} and
\code{graph}.}

\item{sess}{The active TensorFlow session.}

\item{signature_name}{The named entry point to use in the model for prediction.}

\item{...}{See \code{\link[=predict_savedmodel.export_prediction]{predict_savedmodel.export_prediction()}},
\code{\link[=predict_savedmodel.graph_prediction]{predict_savedmodel.graph_prediction()}},
\code{\link[=predict_savedmodel.webapi_prediction]{predict_savedmodel.webapi_prediction()}} for additional options.

#' @section Implementations:
\itemize{
\item \code{\link[=predict_savedmodel.export_prediction]{predict_savedmodel.export_prediction()}}
\item \code{\link[=predict_savedmodel.graph_prediction]{predict_savedmodel.graph_prediction()}}
\item \code{\link[=predict_savedmodel.webapi_prediction]{predict_savedmodel.webapi_prediction()}}]
}}
}
\description{
Performs a prediction using a SavedModel model already loaded using
\code{load_savedmodel()}.
}
