% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session_run_hooks_builtin_wrappers.R
\name{hook_logging_tensor}
\alias{hook_logging_tensor}
\title{Prints Given Tensors Every N Local Steps, Every N Seconds, or at End}
\usage{
hook_logging_tensor(
  tensors,
  every_n_iter = NULL,
  every_n_secs = NULL,
  formatter = NULL,
  at_end = FALSE
)
}
\arguments{
\item{tensors}{A list that maps string-valued tags to tensors/tensor names.}

\item{every_n_iter}{An integer value, indicating the values of \code{tensors} will be printed
once every N local steps taken on the current worker.}

\item{every_n_secs}{An integer or float value, indicating the values of \code{tensors} will be printed
once every N seconds. Exactly one of \code{every_n_iter} and \code{every_n_secs} should be provided.}

\item{formatter}{A function that takes \code{list(tag = tensor)} and returns a
string. If \code{NULL} uses default printing all tensors.}

\item{at_end}{A boolean value specifying whether to print the values of \code{tensors} at the
end of the run.}
}
\description{
The tensors will be printed to the log, with \code{INFO} severity.
}
\details{
Note that if \code{at_end} is \code{TRUE}, \code{tensors} should not include any tensor
whose evaluation produces a side effect such as consuming additional inputs.
}
\seealso{
Other session_run_hook wrappers: 
\code{\link{hook_checkpoint_saver}()},
\code{\link{hook_global_step_waiter}()},
\code{\link{hook_history_saver}()},
\code{\link{hook_nan_tensor}()},
\code{\link{hook_progress_bar}()},
\code{\link{hook_step_counter}()},
\code{\link{hook_stop_at_step}()},
\code{\link{hook_summary_saver}()},
\code{\link{session_run_hook}()}
}
\concept{session_run_hook wrappers}
