% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignite_dataset.R
\name{ignite_dataset}
\alias{ignite_dataset}
\title{Create a \code{IgniteDataset}.}
\usage{
ignite_dataset(cache_name, host = "localhost", port = 10800,
  local = FALSE, part = -1, page_size = 100, username = NULL,
  password = NULL, certfile = NULL, keyfile = NULL,
  cert_password = NULL)
}
\arguments{
\item{cache_name}{Cache name to be used as datasource.}

\item{host}{Apache Ignite Thin Client host to be connected.}

\item{port}{Apache Ignite Thin Client port to be connected.}

\item{local}{Local flag that defines to query only local data.}

\item{part}{Number of partitions to be queried.}

\item{page_size}{Apache Ignite Thin Client page size.}

\item{username}{Apache Ignite Thin Client authentication username.}

\item{password}{Apache Ignite Thin Client authentication password.}

\item{certfile}{File in PEM format containing the certificate as well as any
number of CA certificates needed to establish the certificate's
authenticity.}

\item{keyfile}{File containing the private key (otherwise the private key
will be taken from certfile as well).}

\item{cert_password}{Password to be used if the private key is encrypted and
a password is necessary.}
}
\description{
Apache Ignite is a memory-centric distributed database, caching, and
processing platform for transactional, analytical, and streaming workloads,
delivering in-memory speeds at petabyte scale. This contrib package
contains an integration between Apache Ignite and TensorFlow. The
integration is based on tf.data from TensorFlow side and Binary Client
Protocol from Apache Ignite side. It allows to use Apache Ignite as a
datasource for neural network training, inference and all other
computations supported by TensorFlow. Ignite Dataset is based on Apache
Ignite Binary Client Protocol.
}
\examples{
\dontrun{
dataset <- ignite_dataset(
    cache_name = "SQL_PUBLIC_TEST_CACHE", port = 10800) \%>\%
  dataset_repeat(1)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
