% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_dataset.R
\name{kafka_dataset}
\alias{kafka_dataset}
\title{Creates a \code{KafkaDataset}.}
\usage{
kafka_dataset(topics, servers = "localhost", group = "", eof = FALSE,
  timeout = 1000)
}
\arguments{
\item{topics}{A \code{tf.string} tensor containing one or more subscriptions, in
the format of \code{[topic:partition:offset:length]}, by default length is -1
for unlimited.}

\item{servers}{A list of bootstrap servers.}

\item{group}{The consumer group id.}

\item{eof}{If True, the kafka reader will stop on EOF.}

\item{timeout}{The timeout value for the Kafka Consumer to wait (in
millisecond).}
}
\description{
Creates a \code{KafkaDataset}.
}
\examples{
\dontrun{
dataset <- kafka_dataset(
    topics = list("test:0:0:4"), group = "test", eof = TRUE) \%>\%
  dataset_repeat(1)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
