% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libsvm_dataset.R
\name{make_libsvm_dataset}
\alias{make_libsvm_dataset}
\title{Create a Dataset from LibSVM files.}
\usage{
make_libsvm_dataset(file_names, num_features, dtype = NULL,
  label_dtype = NULL, batch_size = 1, compression_type = "",
  buffer_size = NULL, num_parallel_parser_calls = NULL,
  drop_final_batch = FALSE, prefetch_buffer_size = 0)
}
\arguments{
\item{file_names}{A \code{tf.string} tensor containing one or more filenames.}

\item{num_features}{The number of features.}

\item{dtype}{The type of the output feature tensor. Default to \code{tf.float32}.}

\item{label_dtype}{The type of the output label tensor. Default to
\code{tf.int64}.}

\item{batch_size}{An integer representing the number of records to combine in
a single batch, default 1.}

\item{compression_type}{A \code{tf.string} scalar evaluating to one of \code{""} (no
compression), \code{"ZLIB"}, or \code{"GZIP"}.}

\item{buffer_size}{A \code{tf.int64} scalar denoting the number of bytes to
buffer. A value of 0 results in the default buffering values chosen based
on the compression type.}

\item{num_parallel_parser_calls}{Number of parallel records to parse in
parallel. Defaults to an automatic selection.}

\item{drop_final_batch}{Whether the last batch should be dropped in case its
size is smaller than \code{batch_size}; the default behavior is not to drop the
smaller batch.}

\item{prefetch_buffer_size}{An integer specifying the number of feature
batches to prefetch for performance improvement. Defaults to auto-tune. Set
to 0 to disable prefetching.}
}
\description{
Create a Dataset from LibSVM files.
}
