% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_correlation_cholesky}
\alias{tfb_correlation_cholesky}
\title{Maps unconstrained reals to Cholesky-space correlation matrices.}
\usage{
tfb_correlation_cholesky(validate_args = FALSE,
  name = "correlation_cholesky")
}
\arguments{
\item{validate_args}{Logical, default FALSE. Whether to validate input with asserts. If validate_args is
FALSE, and the inputs are invalid, correct behavior is not guaranteed.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a bijector instance.
}
\description{
This bijector is a mapping between \code{R^{n}} and the \code{n}-dimensional manifold of
Cholesky-space correlation matrices embedded in \code{R^{m^2}}, where \code{n} is the
\code{(m - 1)}th triangular number; i.e. \code{n = 1 + 2 + ... + (m - 1)}.
}
\details{
Mathematical Details

The image of unconstrained reals under the \code{CorrelationCholesky} bijector is
the set of correlation matrices which are positive definite.
A \href{https://en.wikipedia.org/wiki/Correlation_and_dependence#Correlation_matrices}{correlation matrix}
can be characterized as a symmetric positive semidefinite matrix with 1s on
the main diagonal. However, the correlation matrix is positive definite if no
component can be expressed as a linear combination of the other components.
For a lower triangular matrix \code{L} to be a valid Cholesky-factor of a positive
definite correlation matrix, it is necessary and sufficient that each row of
\code{L} have unit Euclidean norm. To see this, observe that if \code{L_i} is the
\code{i}th row of the Cholesky factor corresponding to the correlation matrix \code{R},
then the \code{i}th diagonal entry of \code{R} satisfies:\preformatted{1 = R_i,i = L_i . L_i = ||L_i||^2
}

where '.' is the dot product of vectors and \code{||...||} denotes the Euclidean
norm. Furthermore, observe that \code{R_i,j} lies in the interval \code{[-1, 1]}. By the
Cauchy-Schwarz inequality:\preformatted{|R_i,j| = |L_i . L_j| <= ||L_i|| ||L_j|| = 1
}

This is a consequence of the fact that \code{R} is symmetric positive definite with
1s on the main diagonal.
The LKJ distribution with \code{input_output_cholesky=TRUE} generates samples from
(and computes log-densities on) the set of Cholesky factors of positive
definite correlation matrices. The \code{CorrelationCholesky} bijector provides
a bijective mapping from unconstrained reals to the support of the LKJ
distribution.
}
\section{References}{

\itemize{
\item \href{https://mc-stan.org/docs/2_18/functions-reference/cholesky-lkj-correlation-distribution.html}{Stan Manual. Section 24.2. Cholesky LKJ Correlation Distribution.}
\item Daniel Lewandowski, Dorota Kurowicka, and Harry Joe, "Generating random correlation matrices based on vines and extended onion method," Journal of Multivariate Analysis 100 (2009), pp 1989-2001.
}
}

\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: \code{\link{tfb_absolute_value}},
  \code{\link{tfb_affine_linear_operator}},
  \code{\link{tfb_affine_scalar}},
  \code{\link{tfb_affine}},
  \code{\link{tfb_batch_normalization}},
  \code{\link{tfb_blockwise}}, \code{\link{tfb_chain}},
  \code{\link{tfb_cholesky_outer_product}},
  \code{\link{tfb_cholesky_to_inv_cholesky}},
  \code{\link{tfb_discrete_cosine_transform}},
  \code{\link{tfb_expm1}}, \code{\link{tfb_exp}},
  \code{\link{tfb_fill_triangular}},
  \code{\link{tfb_gumbel}}, \code{\link{tfb_identity}},
  \code{\link{tfb_inline}}, \code{\link{tfb_invert}},
  \code{\link{tfb_kumaraswamy}},
  \code{\link{tfb_masked_autoregressive_default_template}},
  \code{\link{tfb_masked_autoregressive_flow}},
  \code{\link{tfb_masked_dense}},
  \code{\link{tfb_matrix_inverse_tri_l}},
  \code{\link{tfb_matvec_lu}},
  \code{\link{tfb_normal_cdf}}, \code{\link{tfb_ordered}},
  \code{\link{tfb_permute}},
  \code{\link{tfb_power_transform}},
  \code{\link{tfb_real_nvp_default_template}},
  \code{\link{tfb_real_nvp}}, \code{\link{tfb_reciprocal}},
  \code{\link{tfb_reshape}}, \code{\link{tfb_scale_tri_l}},
  \code{\link{tfb_sigmoid}},
  \code{\link{tfb_sinh_arcsinh}},
  \code{\link{tfb_softmax_centered}},
  \code{\link{tfb_softplus}}, \code{\link{tfb_softsign}},
  \code{\link{tfb_square}}, \code{\link{tfb_tanh}},
  \code{\link{tfb_transform_diagonal}},
  \code{\link{tfb_transpose}}, \code{\link{tfb_weibull}}
}
\concept{bijectors}
