% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_student_t_process}
\alias{tfd_student_t_process}
\title{Marginal distribution of a Student's T process at finitely many points}
\usage{
tfd_student_t_process(df, kernel, index_points, mean_fn = NULL,
  jitter = 1e-06, validate_args = FALSE, allow_nan_stats = FALSE,
  name = "StudentTProcess")
}
\arguments{
\item{df}{Positive Floating-point \code{Tensor} representing the degrees of freedom.
Must be greater than 2.}

\item{kernel}{\code{PositiveSemidefiniteKernel}-like instance representing the
TP's covariance function.}

\item{index_points}{\code{float} \code{Tensor} representing finite (batch of) vector(s) of
points in the index set over which the TP is defined. Shape has the form
\code{[b1, ..., bB, e, f1, ..., fF]} where \code{F} is the number of feature
dimensions and must equal \code{kernel.feature_ndims} and \code{e} is the number
(size) of index points in each batch. Ultimately this distribution
corresponds to a \code{e}-dimensional multivariate Student's T. The batch
shape must be broadcastable with \code{kernel.batch_shape} and any batch dims
yielded by \code{mean_fn}.}

\item{mean_fn}{Function that acts on \code{index_points} to produce a (batch
of) vector(s) of mean values at \code{index_points}. Takes a \code{Tensor} of
shape \code{[b1, ..., bB, f1, ..., fF]} and returns a \code{Tensor} whose shape is
broadcastable with \code{[b1, ..., bB]}. Default value: \code{NULL} implies
constant zero function.}

\item{jitter}{\code{float} scalar \code{Tensor} added to the diagonal of the covariance
matrix to ensure positive definiteness of the covariance matrix. Default value: \code{1e-6}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
A Student's T process (TP) is an indexed collection of random variables, any
finite collection of which are jointly Multivariate Student's T. While this
definition applies to finite index sets, it is typically implicit that the
index set is infinite; in applications, it is often some finite dimensional
real or complex vector space. In such cases, the TP may be thought of as a
distribution over (real- or complex-valued) functions defined over the index set.
}
\details{
Just as Student's T distributions are fully specified by their degrees of
freedom, location and scale, a Student's T process can be completely specified
by a degrees of freedom parameter, mean function and covariance function.

Let \code{S} denote the index set and \code{K} the space in which each indexed random variable
takes its values (again, often R or C).
The mean function is then a map \code{m: S -> K}, and the covariance function,
or kernel, is a positive-definite function \code{k: (S x S) -> K}. The properties
of functions drawn from a TP are entirely dictated (up to translation) by
the form of the kernel function.

This \code{Distribution} represents the marginal joint distribution over function
values at a given finite collection of points \code{[x[1], ..., x[N]]} from the
index set \code{S}. By definition, this marginal distribution is just a
multivariate Student's T distribution, whose mean is given by the vector
\code{[ m(x[1]), ..., m(x[N]) ]} and whose covariance matrix is constructed from
pairwise applications of the kernel function to the given inputs:\preformatted{| k(x[1], x[1])    k(x[1], x[2])  ...  k(x[1], x[N]) |
| k(x[2], x[1])    k(x[2], x[2])  ...  k(x[2], x[N]) |
|      ...              ...                 ...      |
| k(x[N], x[1])    k(x[N], x[2])  ...  k(x[N], x[N]) |

}

For this to be a valid covariance matrix, it must be symmetric and positive
definite; hence the requirement that \code{k} be a positive definite function
(which, by definition, says that the above procedure will yield PD matrices).
Note also we use a parameterization as suggested in Shat et al. (2014), which requires \code{df}
to be greater than 2. This allows for the covariance for any finite
dimensional marginal of the TP (a multivariate Student's T distribution) to
just be the PD matrix generated by the kernel.

Mathematical Details

The probability density function (pdf) is a multivariate Student's T whose
parameters are derived from the TP's properties:\preformatted{pdf(x; df, index_points, mean_fn, kernel) = MultivariateStudentT(df, loc, K)
K = (df - 2) / df  * (kernel.matrix(index_points, index_points) + jitter * eye(N))
loc = (x - mean_fn(index_points))^T @ K @ (x - mean_fn(index_points))
}

where:
\itemize{
\item \code{df} is the degrees of freedom parameter for the TP.
\item \code{index_points} are points in the index set over which the TP is defined,
\item \code{mean_fn} is a callable mapping the index set to the TP's mean values,
\item \code{kernel} is \code{PositiveSemidefiniteKernel}-like and represents the covariance
function of the TP,
\item \code{jitter} is added to the diagonal to ensure positive definiteness up to
machine precision (otherwise Cholesky-decomposition is prone to failure),
\item \code{eye(N)} is an N-by-N identity matrix.
}
}
\section{References}{

\itemize{
\item \href{https://www.cs.cmu.edu/~andrewgw/tprocess.pdf}{Amar Shah, Andrew Gordon Wilson, and Zoubin Ghahramani. Student-t Processes as Alternatives to Gaussian Processes. In Artificial Intelligence and Statistics, 2014.}
}
}

\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: \code{\link{tfd_autoregressive}},
  \code{\link{tfd_batch_reshape}},
  \code{\link{tfd_bernoulli}}, \code{\link{tfd_beta}},
  \code{\link{tfd_binomial}},
  \code{\link{tfd_categorical}}, \code{\link{tfd_cauchy}},
  \code{\link{tfd_chi2}}, \code{\link{tfd_chi}},
  \code{\link{tfd_cholesky_lkj}},
  \code{\link{tfd_deterministic}},
  \code{\link{tfd_dirichlet_multinomial}},
  \code{\link{tfd_dirichlet}}, \code{\link{tfd_empirical}},
  \code{\link{tfd_exponential}},
  \code{\link{tfd_gamma_gamma}}, \code{\link{tfd_gamma}},
  \code{\link{tfd_gaussian_process_regression_model}},
  \code{\link{tfd_gaussian_process}},
  \code{\link{tfd_geometric}}, \code{\link{tfd_gumbel}},
  \code{\link{tfd_half_cauchy}},
  \code{\link{tfd_half_normal}},
  \code{\link{tfd_hidden_markov_model}},
  \code{\link{tfd_horseshoe}},
  \code{\link{tfd_independent}},
  \code{\link{tfd_inverse_gamma}},
  \code{\link{tfd_inverse_gaussian}},
  \code{\link{tfd_joint_distribution_named}},
  \code{\link{tfd_joint_distribution_sequential}},
  \code{\link{tfd_kumaraswamy}}, \code{\link{tfd_laplace}},
  \code{\link{tfd_linear_gaussian_state_space_model}},
  \code{\link{tfd_lkj}}, \code{\link{tfd_log_normal}},
  \code{\link{tfd_logistic}},
  \code{\link{tfd_mixture_same_family}},
  \code{\link{tfd_mixture}}, \code{\link{tfd_multinomial}},
  \code{\link{tfd_multivariate_normal_diag_plus_low_rank}},
  \code{\link{tfd_multivariate_normal_diag}},
  \code{\link{tfd_multivariate_normal_full_covariance}},
  \code{\link{tfd_multivariate_normal_linear_operator}},
  \code{\link{tfd_multivariate_normal_tri_l}},
  \code{\link{tfd_multivariate_student_t_linear_operator}},
  \code{\link{tfd_negative_binomial}},
  \code{\link{tfd_normal}},
  \code{\link{tfd_one_hot_categorical}},
  \code{\link{tfd_pareto}},
  \code{\link{tfd_poisson_log_normal_quadrature_compound}},
  \code{\link{tfd_poisson}}, \code{\link{tfd_quantized}},
  \code{\link{tfd_relaxed_bernoulli}},
  \code{\link{tfd_relaxed_one_hot_categorical}},
  \code{\link{tfd_sample_distribution}},
  \code{\link{tfd_sinh_arcsinh}},
  \code{\link{tfd_student_t}},
  \code{\link{tfd_transformed_distribution}},
  \code{\link{tfd_triangular}},
  \code{\link{tfd_truncated_normal}},
  \code{\link{tfd_uniform}},
  \code{\link{tfd_variational_gaussian_process}},
  \code{\link{tfd_vector_diffeomixture}},
  \code{\link{tfd_vector_exponential_diag}},
  \code{\link{tfd_vector_exponential_linear_operator}},
  \code{\link{tfd_vector_laplace_diag}},
  \code{\link{tfd_vector_laplace_linear_operator}},
  \code{\link{tfd_vector_sinh_arcsinh_diag}},
  \code{\link{tfd_von_mises_fisher}},
  \code{\link{tfd_von_mises}}, \code{\link{tfd_wishart}},
  \code{\link{tfd_zipf}}
}
\concept{distributions}
