% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_uncalibrated_random_walk}
\alias{mcmc_uncalibrated_random_walk}
\title{Generate proposal for the Random Walk Metropolis algorithm.}
\usage{
mcmc_uncalibrated_random_walk(target_log_prob_fn, new_state_fn = NULL,
  seed = NULL, name = NULL)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} ((if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{new_state_fn}{Function which takes a list of state parts and a
seed; returns a same-type \code{list} of \code{Tensor}s, each being a perturbation
of the input state parts. The perturbation distribution is assumed to be
a symmetric distribution centered at the input state part.
Default value: \code{NULL} which is mapped to \code{tfp$mcmc$random_walk_normal_fn()}.}

\item{seed}{integer to seed the random number generator.}

\item{name}{String name prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., 'rwm_kernel').}
}
\value{
a Monte Carlo sampling kernel
}
\description{
Warning: this kernel will not result in a chain which converges to the
\code{target_log_prob}. To get a convergent MCMC, use
\code{mcmc_random_walk_metropolis(...)} or
\code{mcmc_metropolis_hastings(mcmc_uncalibrated_random_walk(...))}.
}
\seealso{
Other mcmc_kernels: \code{\link{mcmc_dual_averaging_step_size_adaptation}},
  \code{\link{mcmc_hamiltonian_monte_carlo}},
  \code{\link{mcmc_metropolis_adjusted_langevin_algorithm}},
  \code{\link{mcmc_metropolis_hastings}},
  \code{\link{mcmc_no_u_turn_sampler}},
  \code{\link{mcmc_random_walk_metropolis}},
  \code{\link{mcmc_replica_exchange_mc}},
  \code{\link{mcmc_simple_step_size_adaptation}},
  \code{\link{mcmc_slice_sampler}},
  \code{\link{mcmc_transformed_transition_kernel}},
  \code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}},
  \code{\link{mcmc_uncalibrated_langevin}}
}
\concept{mcmc_kernels}
