###################################################
### chunk number 1: 
###################################################
library(tgp)
seed <- 0; set.seed(seed)


###################################################
### chunk number 2: 
###################################################
f <- friedman.1.data(250) 


###################################################
### chunk number 3: 
###################################################
Xf <- f[, 1:6] 
Zf <- f$Y 
sf <- sens(X=Xf, Z=Zf, nn.lhs=600, model=bgpllm, verb=0)


###################################################
### chunk number 4: 
###################################################
names(sf$sens)


###################################################
### chunk number 5: sens-full
###################################################
plot(sf, layout="sens", legendloc="topleft")


###################################################
### chunk number 6: 
###################################################
graphics.off()


###################################################
### chunk number 7: sens-mains
###################################################
par(mar=c(4,2,4,2), mfrow=c(2,3))
plot(sf, layout="sens", maineff=t(1:6))


###################################################
### chunk number 8: 
###################################################
graphics.off()


###################################################
### chunk number 9: sens-indices
###################################################
plot(sf, layout="sens", maineff=FALSE)


###################################################
### chunk number 10: 
###################################################
graphics.off()


###################################################
### chunk number 11: 
###################################################
X <- airquality[,2:4]
Z <- airquality$Ozone
rect <- t(apply(X, 2, range, na.rm=TRUE))
mode <- apply(X , 2, mean, na.rm=TRUE)
shape <- rep(2,3)


###################################################
### chunk number 12: sens-udraw
###################################################
Udraw <- lhs(300, rect=rect, mode=mode, shape=shape)
par(mfrow=c(1,3), mar=c(4,2,4,2))
for(i in 1:3){
  hist(Udraw[,i], breaks=10,xlab=names(X)[i], 
       main="",ylab="", border=grey(.9), col=8) 
}  


###################################################
### chunk number 13: 
###################################################
graphics.off()


###################################################
### chunk number 14: 
###################################################
s.air <- suppressWarnings(sens(X=X, Z=Z, nn.lhs=300, rect=rect, 
                               shape=shape, mode=mode, verb=0))


###################################################
### chunk number 15: sens-air1
###################################################
plot(s.air, layout="sens")


###################################################
### chunk number 16: 
###################################################
graphics.off()


###################################################
### chunk number 17: 
###################################################
rect[2,] <- c(0,5)
mode[2] <- 2
shape[2] <- 2


###################################################
### chunk number 18: 
###################################################
sens.p <- suppressWarnings(sens(X=X,Z=Z,nn.lhs=300, model=NULL, rect=rect, shape=shape, mode=mode))


###################################################
### chunk number 19: sens-air2
###################################################
s.air2 <- predict.tgp(s.air, BTE=c(1,1000,1), sens.p=sens.p, verb=0) 
plot(s.air2, layout="sens")


###################################################
### chunk number 20: 
###################################################
graphics.off()


###################################################
### chunk number 21: 
###################################################
X$Temp[X$Temp >70] <- 1
X$Temp[X$Temp >1] <- 0
rect <- t(apply(X, 2, range, na.rm=TRUE))
mode <- apply(X , 2, mean, na.rm=TRUE)
shape <- c(2,2,0)
s.air <- suppressWarnings(sens(X=X, Z=Z, nn.lhs=300, rect=rect, 
                               shape=shape, mode=mode, verb=0, basemax=2))


###################################################
### chunk number 22: sens-air3
###################################################
plot(s.air, layout="sens")


###################################################
### chunk number 23: 
###################################################
graphics.off()


