% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_top_features.R
\name{compute_top_features}
\alias{compute_top_features}
\title{Return an object containing results from top-performing features on a classification task}
\usage{
compute_top_features(
  data,
  num_features = 40,
  normalise_violin_plots = FALSE,
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  cor_method = c("pearson", "spearman"),
  test_method = "gaussprRadial",
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  use_balanced_accuracy = FALSE,
  use_k_fold = FALSE,
  num_folds = 10,
  use_empirical_null = FALSE,
  null_testing_method = c("ModelFreeShuffles", "NullModelFits"),
  p_value_method = c("empirical", "gaussian"),
  num_permutations = 50,
  pool_empirical_null = FALSE,
  seed = 123
)
}
\arguments{
\item{data}{the \code{feature_calculations} object containing the raw feature matrix produced by \code{calculate_features}}

\item{num_features}{\code{integer} denoting the number of top features to retain and explore. Defaults to \code{40}}

\item{normalise_violin_plots}{\code{Boolean} of whether to normalise features before plotting. Defaults to \code{FALSE}}

\item{method}{a rescaling/normalising method to apply to violin plots. Defaults to \code{"z-score"}}

\item{cor_method}{\code{string} denoting the correlation method to use. Defaults to \code{"pearson"}}

\item{test_method}{\code{string} specifying the algorithm to use for quantifying class separation. Defaults to \code{"gaussprRadial"}. Should be either \code{"t-test"}, \code{"wilcox"}, or \code{"binomial logistic"} for two-class problems to obtain exact statistics, or a valid \code{caret} classification model for everything else}

\item{clust_method}{\code{string} denoting the hierarchical clustering method to use for the pairwise correlation plot. Defaults to \code{"average"}}

\item{use_balanced_accuracy}{\code{Boolean} specifying whether to use balanced accuracy as the summary metric for caret model training. Defaults to \code{FALSE}}

\item{use_k_fold}{\code{Boolean} specifying whether to use k-fold procedures for generating a distribution of classification accuracy estimates if a \code{caret} model is specified for \code{test_method}. Defaults to \code{ FALSE}}

\item{num_folds}{\code{integer} specifying the number of k-folds to perform if \code{use_k_fold} is set to \code{TRUE}. Defaults to \code{10}}

\item{use_empirical_null}{\code{Boolean} specifying whether to use empirical null procedures to compute p-values if a \code{caret} model is specified for \code{test_method}. Defaults to \code{FALSE}}

\item{null_testing_method}{\code{string} specifying the type of statistical method to use to calculate p-values. Defaults to \code{"ModelFreeShuffles"}}

\item{p_value_method}{\code{string} specifying the method of calculating p-values. Defaults to \code{"empirical"}}

\item{num_permutations}{\code{integer} specifying the number of class label shuffles to perform if \code{use_empirical_null} is \code{TRUE}. Defaults to \code{50}}

\item{pool_empirical_null}{\code{Boolean} specifying whether to use the pooled empirical null distribution of all features or each features' individual empirical null distribution if a \code{caret} model is specified for \code{test_method} use_empirical_null is \code{TRUE}. Defaults to \code{FALSE}}

\item{seed}{\code{integer} denoting a fixed number for R's random number generator to ensure reproducibility}
}
\value{
an object of class \code{list} containing a \code{data.frame} of results, a \code{ggplot} feature x feature matrix plot, and a \code{ggplot} violin plot
}
\description{
Return an object containing results from top-performing features on a classification task
}
\examples{
\donttest{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)
  
compute_top_features(featMat,
  num_features = 10,
  normalise_violin_plots = FALSE,
  method = "RobustSigmoid",
  cor_method = "pearson",
  test_method = "gaussprRadial",
  clust_method = "average",
  use_balanced_accuracy = FALSE,
  use_k_fold = FALSE,
  num_folds = 10,
  use_empirical_null = TRUE,
  null_testing_method = "ModelFreeShuffles",
  p_value_method = "gaussian",
  num_permutations = 100,
  pool_empirical_null = FALSE,
  seed = 123) 
}

}
\author{
Trent Henderson
}
