% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_single_feature_classifier.R
\name{fit_single_feature_classifier}
\alias{fit_single_feature_classifier}
\title{Fit a classifier to feature matrix to extract top performers}
\usage{
fit_single_feature_classifier(
  data,
  test_method = "gaussprRadial",
  use_balanced_accuracy = FALSE,
  use_k_fold = FALSE,
  num_folds = 10,
  use_empirical_null = FALSE,
  null_testing_method = c("ModelFreeShuffles", "NullModelFits"),
  p_value_method = c("empirical", "gaussian"),
  num_permutations = 50,
  pool_empirical_null = FALSE,
  seed = 123
)
}
\arguments{
\item{data}{the \code{data.frame} containing the raw feature matrix}

\item{test_method}{\code{string} specifying the algorithm to use for quantifying class separation. Defaults to \code{"gaussprRadial"}. Should be either \code{"t-test"}, \code{"wilcox"}, or \code{"binomial logistic"} for two-class problems to obtain exact statistics, or a valid \code{caret} classification model for everything else}

\item{use_balanced_accuracy}{\code{Boolean} specifying whether to use balanced accuracy as the summary metric for caret model training. Defaults to \code{FALSE}}

\item{use_k_fold}{\code{Boolean} specifying whether to use k-fold procedures for generating a distribution of classification accuracy estimates if a \code{caret} model is specified for \code{test_method}. Defaults to \code{ FALSE}}

\item{num_folds}{\code{integer} specifying the number of k-folds to perform if \code{use_k_fold} is set to \code{TRUE}. Defaults to \code{10}}

\item{use_empirical_null}{\code{Boolean} specifying whether to use empirical null procedures to compute p-values if a \code{caret} model is specified for \code{test_method}. Defaults to \code{FALSE}}

\item{null_testing_method}{\code{string} specifying the type of statistical method to use to calculate p-values. Defaults to \code{model free shuffles}}

\item{p_value_method}{\code{string} specifying the method of calculating p-values. Defaults to \code{"empirical"}}

\item{num_permutations}{\code{integer} specifying the number of class label shuffles to perform if \code{use_empirical_null} is \code{TRUE}. Defaults to \code{50}}

\item{pool_empirical_null}{\code{Boolean} specifying whether to use the pooled empirical null distribution of all features or each features' individual empirical null distribution if a \code{caret} model is specified for \code{test_method} use_empirical_null is \code{TRUE}. Defaults to \code{FALSE}}

\item{seed}{\code{integer} denoting a fixed number for R's random number generator to ensure reproducibility}
}
\value{
an object of class \code{data.frame}
}
\description{
Fit a classifier to feature matrix to extract top performers
}
\author{
Trent Henderson
}
