% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenodo.R
\name{add_zenodo_json}
\alias{add_zenodo_json}
\alias{add_zenodo_json_theory}
\title{Add 'Zenodo' JSON File}
\usage{
add_zenodo_json(path, title, upload_type, keywords)

add_zenodo_json_theory(path, title, keywords)
}
\arguments{
\item{path}{Character, indicating the directory in which to create the FAIR
theory.}

\item{title}{Character, indicating the theory title. Default: \code{NULL}}

\item{upload_type}{Character, indicating the upload type.}

\item{keywords}{Character vector of keywords.}
}
\value{
Invisibly returns a logical value,
indicating whether the function was successful or not.
}
\description{
Writes a '.zenodo.json' file to the specified path.

Writes a README file to a specific path.
}
\examples{
add_zenodo_json(path = tempdir(), title = "Theory Title",
                upload_type = "software", keywords = "R")
add_zenodo_json_theory(path = tempdir(), title = "My Theory",
                       keywords = "secondkeyword")
add_zenodo_json_theory(path = tempdir(), title = "My Theory",
                       keywords = c("secondkeyword", "thirdkeyword"))
}
\seealso{
\code{\link[jsonlite]{read_json}}
}
