% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdb_cursor.R
\name{mdb_cursor}
\alias{mdb_cursor}
\title{Use mdb transactions}
\description{
Cursors are required for some advanced queries on an mdb database,
when the basic set of functions in \code{\link{mdb_txn}} is not
sufficient.
}
\details{
Cursors must be created from within a transaction (which in turn
are created from an environment).
}
\section{Methods}{


\describe{
\item{\code{close}}{
  Close the cursor

  \emph{Usage:}
  \code{close()}

  \emph{Value}:
  None, called for side effects only

  \emph{Note}: In lmdb.h this is \code{mdb_cursor_close()}
}
\item{\code{put}}{
  Store data using the cursor

  \emph{Usage:}
  \code{put(key, value, dupdata = TRUE, overwrite = TRUE, append = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{key}:   The key (string or raw)
    }

    \item{\code{value}:   The value (string or raw)
    }

    \item{\code{dupdata}:   As for \code{\link{mdb_txn}} \code{$put}
    }

    \item{\code{overwrite}:   As for \code{\link{mdb_txn}} \code{$put}
    }

    \item{\code{append}:   As for \code{\link{mdb_txn}} \code{$put}
    }
  }

  \emph{Value}:
  Logical scalar, indicating if data was previously stored at this key

  \emph{Note}: In lmdb.h this is \code{mdb_cursor_put()}
}
\item{\code{del}}{
  Delete the current key

  \emph{Usage:}
  \code{del(dupdata = TRUE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{dupdata}:   Delete all data items for this key in a database with \code{dupdata = TRUE}
    }
  }

  \emph{Value}:
  Logical, indicating if a value was deleted (which will be \code{TRUE} if the cursor was valid before this operation). Primarily called for its side effect of deleting the data.  After deletion, we call \code{mdb_cursor_get} with \code{MDB_GET_CURRENT} which will re-validate the cursor.

  \emph{Note}: In lmdb.h this is \code{mdb_cursor_del()}
}
\item{\code{replace}}{
  Replace a key's current value with a new value, returning the old value.  This is like doing a \code{get()} followed by a \code{put} within a transaction.

  \emph{Usage:}
  \code{replace(key, value, as_raw = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{key}:   The key to replace
    }

    \item{\code{value}:   The new value to store
    }

    \item{\code{as_raw}:   Return the value as raw.  With a value of \code{NULL} it will return a string if possible (i.e., if there are no null bytes) and a raw vector otherwise.  With \code{as_raw = TRUE} we always return a raw vector.  With \code{as_raw = FALSE} we always return a string, or throw an error if this is not possible.
    }
  }
}
\item{\code{pop}}{
  Delete a key's value, returning the value just before it was deleted.  This is like doing a \code{get} followed by a \code{del} within a transaction.

  \emph{Usage:}
  \code{pop(key, as_raw = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{key}:   The key to delete
    }

    \item{\code{as_raw}:   Return the value as raw.  With a value of \code{NULL} it will return a string if possible (i.e., if there are no null bytes) and a raw vector otherwise.  With \code{as_raw = TRUE} we always return a raw vector.  With \code{as_raw = FALSE} we always return a string, or throw an error if this is not possible.
    }
  }

  \emph{Value}:
  Depending on \code{as_raw} and if there is a value stored, \code{NULL}, a character string or a raw vector
}
\item{\code{first}}{
  Move the cursor to the first item in the database

  \emph{Usage:}
  \code{first()}

  \emph{Value}:
  Invisibly, a logical indicating if the cursor position is valid, but primarily called for side effects
}
\item{\code{last}}{
  Move the cursor to the last item in the database

  \emph{Usage:}
  \code{last()}

  \emph{Value}:
  Invisibly, a logical indicating if the cursor position is valid, but primarily called for side effects
}
\item{\code{move_next}}{
  Move the cursor to the next item in the database.  If called while at the last item in the database, this will invalidate the cursor position.

  \emph{Usage:}
  \code{move_next()}

  \emph{Value}:
  Invisibly, a logical indicating if the cursor position is valid, but primarily called for side effects
}
\item{\code{move_prev}}{
  Move the cursor to the previous item in the database.  If called while at the first item in the database, this will invalidate the cursor position.

  \emph{Usage:}
  \code{move_prev()}

  \emph{Value}:
  Invisibly, a logical indicating if the cursor position is valid, but primarily called for side effects
}
\item{\code{move_to}}{
  Move the cursor to the item in the database with key \code{key}. If \code{key} does not exist, this will invalidate the cursor position.

  \emph{Usage:}
  \code{move_to(key)}

  \emph{Arguments:}
  \itemize{
    \item{\code{key}:   Key to move to (string or raw)
    }
  }

  \emph{Value}:
  Invisibly, a logical indicating if the cursor position is valid, but primarily called for side effects
}
\item{\code{seek}}{
  Move the cursor to the item in the database with key equal to or greater than \code{key}.  If \code{key} does not exist and no key with a key greater than \code{key} exists, this will invalidate the cursor position.

  \emph{Usage:}
  \code{seek(key)}

  \emph{Arguments:}
  \itemize{
    \item{\code{key}:   Key to seek (string or raw)
    }
  }

  \emph{Value}:
  Invisibly, a logical indicating if the cursor position is valid, but primarily called for side effects
}
\item{\code{get}}{
  Move to a key and fetch the value

  \emph{Usage:}
  \code{get(key, as_proxy = FALSE, as_raw = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{key}:   The key to find (string or raw)
    }

    \item{\code{as_proxy}:   Return as an \code{\link{mdb_proxy}} object?
    }

    \item{\code{as_raw}:   Return the value as raw.  With a value of \code{NULL} it will return a string if possible (i.e., if there are no null bytes) and a raw vector otherwise.  With \code{as_raw = TRUE} we always return a raw vector.  With \code{as_raw = FALSE} we always return a string, or throw an error if this is not possible.
    }
  }

  \emph{Value}:
  Depending on \code{as_raw} and if there is a value stored, \code{NULL}, a character string or a raw vector
}
\item{\code{is_valid}}{
  Test if cursor is valid (i.e., that it is pointing at data that can be retrieved).  Cursors start off invalid until placed (e.g., \code{first}, \code{last}) and can be invalidated by moving off the beginning or end of the database.

  \emph{Usage:}
  \code{is_valid()}
}
\item{\code{key}}{
  Return the current key

  \emph{Usage:}
  \code{key(as_proxy = FALSE, as_raw = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{as_proxy}:   Return as an \code{\link{mdb_proxy}} object?
    }

    \item{\code{as_raw}:   Return the value as raw.  With a value of \code{NULL} it will return a string if possible (i.e., if there are no null bytes) and a raw vector otherwise.  With \code{as_raw = TRUE} we always return a raw vector.  With \code{as_raw = FALSE} we always return a string, or throw an error if this is not possible.
    }
  }
}
\item{\code{value}}{
  Return the current value

  \emph{Usage:}
  \code{value(as_proxy = FALSE, as_raw = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{as_proxy}:   Return as an \code{\link{mdb_proxy}} object?
    }

    \item{\code{as_raw}:   Return the value as raw.  With a value of \code{NULL} it will return a string if possible (i.e., if there are no null bytes) and a raw vector otherwise.  With \code{as_raw = TRUE} we always return a raw vector.  With \code{as_raw = FALSE} we always return a string, or throw an error if this is not possible.
    }
  }
}
}
}

\examples{
# Start by creating a new environment, and within that a write
# transaction, and from that a new cursor.  But first put a bunch
# of data into the database
env <- thor::mdb_env(tempfile())
env$mput(letters, LETTERS)
txn <- env$begin(write = TRUE)
cur <- txn$cursor()

# Move the cursor to the first position
cur$first()

# The key and value:
cur$key()
cur$value()

# Move to a different key:
cur$move_to("g")
cur$value()

# Delete the current item
cur$del()
cur$key()

# We can't move to 'g' any more as it's gone:
(cur$move_to("g"))
cur$key() # NULL

# But we can *seek* 'g', which will move to 'h'
(cur$seek("g"))
cur$key() # "h"

# Get raw values out:
cur$value(as_raw = TRUE)

# Cleanup
env$destroy()
}
