% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_series.R
\name{create_series}
\alias{create_series}
\title{Create a \code{tbl_time} object with a sequence of regularly spaced dates}
\usage{
create_series(time_formula, period = "daily", class = "POSIXct",
  include_end = FALSE, tz = "UTC", as_vector = FALSE)
}
\arguments{
\item{time_formula}{A period to create the series over.
This is specified as a formula.
See the \code{Details} section of \code{\link[=filter_time]{filter_time()}} for more information.}

\item{period}{A character specification used for time-based grouping. The
general format to use is \code{"frequency period"} where frequency is a number
like 1 or 2, and period is an interval like weekly or yearly. There must be
a space between the two.

Note that you can pass the specification in a flexible way:
\itemize{
\item 1 Year: \code{'1 year'} / \code{'1 Y'} / \code{'1 yearly'} / \code{'yearly'}
}

This shorthand is available for year, quarter, month, day, hour, minute,
second, millisecond and microsecond periodicities.

Additionally, you have the option of passing in a vector of dates to
use as custom and more flexible boundaries.}

\item{class}{One of \code{"Date"}, \code{"POSIXct"}, \code{"hms"}, \code{"yearmon"}, \code{"yearqtr"}.
The default is \code{"POSIXct"}.}

\item{include_end}{Whether to always include the RHS of the \code{time_formula}
even if it does not match the regularly spaced index.}

\item{tz}{Time zone of the new series.}

\item{as_vector}{Should the series be returned as a vector instead of
a tibble?}
}
\description{
\code{\link[=create_series]{create_series()}} allows the user to quickly create a \code{tbl_time} object with
a \code{date} column populated with a sequence of dates.
}
\examples{

# Every day in 2013
create_series(~'2013', 'daily')

# Every other day in 2013
create_series(~'2013', '2 d')

# Every quarter in 2013
create_series(~'2013', '1 q')

# Daily series for 2013-2015
create_series('2013' ~ '2015', '1 d')

# Minute series for 2 months
create_series('2012-01' ~ '2012-02', 'M')

# Second series for 2 minutes
create_series('2011-01-01 12:10:00' ~ '2011-01-01 12:12:00', 's')

# Date class
create_series(~'2013', 'day', class = "Date")

# yearmon class
create_series(~'2013', 'month', class = "yearmon")

# hms class. time_formula specified as HH:MM:SS here
create_series('00:00:00' ~ '12:00:00', 'second' , class = "hms")

# Subsecond series
create_series('2013' ~ '2013-01-01 00:00:01', period = "10 millisec")
milli <- create_series('2013' ~ '2013-01-01 00:00:01', period = ".1 sec")
# Check that 'milli' is correct by running:
# options("digits.secs" = 4)
# options("digits" = 18)
# milli$date
# as.numeric(milli$date)


}
