% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_meta_random.R
\name{bf_meta_random}
\alias{bf_meta_random}
\title{Bayes factor for random-effects meta-analysis}
\usage{
bf_meta_random(
  data,
  d = prior("norm", c(mean = 0, sd = 0.3)),
  tau = prior("invgamma", c(shape = 1, scale = 0.15)),
  metaBMA.args = list(),
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{y}  and \code{SE} arguments in
\code{metaBMA::meta_random}.}

\item{d}{\code{prior} distribution on the average effect size \code{d}. The
prior probability density function is defined via \code{\link[metaBMA]{prior}}.}

\item{tau}{\code{prior} distribution on the between-study heterogeneity
\code{tau} (i.e., the standard deviation of the study effect sizes
\code{dstudy} in a random-effects meta-analysis. A (nonnegative) prior
probability density function is defined via \code{\link[metaBMA]{prior}}.}

\item{metaBMA.args}{A list of additional arguments to be passed to
\code{metaBMA::meta_random}.}

\item{...}{
  Arguments passed on to \code{\link[=bf_extractor]{bf_extractor}}
  \describe{
    \item{\code{conf.level}}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}
    \item{\code{centrality}}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}
    \item{\code{conf.method}}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default, see \code{\link[bayestestR:hdi]{bayestestR::hdi()}}), \code{"eti"} (see
\code{\link[bayestestR:eti]{bayestestR::eti()}}) or \code{"si"} (see \code{\link[bayestestR:si]{bayestestR::si()}}).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{top.text}}{Text to display as top.text (will be displayed on top of the
Bayes Factor top.text/message).}
    \item{\code{output}}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}
  }}
}
\description{
Bayes factor for random-effects meta-analysis
}
\examples{

\donttest{
# setup
set.seed(123)
library(metaBMA)

# creating a dataframe
(df <-
  structure(
    .Data = list(
      study = c("1", "2", "3", "4", "5"),
      estimate = c(
        0.382047603321706,
        0.780783111514665,
        0.425607573765058,
        0.558365541235078,
        0.956473848429961
      ),
      std.error = c(
        0.0465576338644502,
        0.0330218199731529,
        0.0362834986178494,
        0.0480571500648261,
        0.062215818388157
      )
    ),
    row.names = c(NA, -5L),
    class = c("tbl_df", "tbl", "data.frame")
  ))

# to get dataframe
bf_meta_random(
  data = df,
  k = 3,
  metaBMA.args = list(iter = 500, rscale_discrete = 0.880),
  output = "dataframe"
)
}

}
