% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\encoding{UTF-8}
\name{bde_series_full_load}
\alias{bde_series_full_load}
\title{Load BdE full time-series files}
\usage{
bde_series_full_load(
  series_csv,
  parse_dates = TRUE,
  parse_numeric = TRUE,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  extract_metadata = FALSE
)
}
\arguments{
\item{series_csv}{csv file of a series, as defined in the field
\verb{Nombre del archivo con los valores de la serie} of the corresponding
catalog. See \code{\link[=bde_catalog_load]{bde_catalog_load()}}.}

\item{parse_dates}{Logical. If TRUE the dates would be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}

\item{parse_numeric}{Logical. If TRUE the columns would be parsed to double
(numeric) values. See Note.}

\item{cache_dir}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}

\item{update_cache}{Logical. If TRUE the requested file would be updated on
the \code{cache_dir}.}

\item{verbose}{Logical, display information useful for debugging.}

\item{extract_metadata}{Logical TRUE/FALSE. On TRUE the output is the
metadata of the requested series.}
}
\value{
A tibble with a field "Date" and the alias of the fields series as
described on the catalogs. See \code{\link[=bde_catalog_load]{bde_catalog_load()}}.
}
\description{
Load a full time-series file provided by BdE.
\subsection{About BdE file naming}{

The series name is a positional code showing the location of the table. For
example, table \strong{be_6_1} represents the Table 1, Chapter 6 of the
Statistical Bulletin. Although it is a unique value, it is subject to
change (i.e. a new table is inserted before).

For that reason, the function \code{\link[=bde_series_load]{bde_series_load()}} is more suitable for
extracting specific time-series.
}
}
\note{
This function tries to coerce the columns to numbers. For some series a
warning may be displayed if the parser fails. You can override the default
behavior with \code{parse_numeric = FALSE}
}
\examples{
\donttest{
# Metadata
bde_series_full_load("TI_1_1.csv", extract_metadata = TRUE)

# Data
bde_series_full_load("TI_1_1.csv")
}
}
\seealso{
\code{\link[=bde_series_load]{bde_series_load()}}
}
\concept{series}
