% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_tableGen_utils.R
\name{data_to_use_str}
\alias{data_to_use_str}
\title{Function to clean and combine ADAE dataset with ADSL}
\usage{
data_to_use_str(x, ae_data, bds_data)
}
\arguments{
\item{x}{string, naming a data.frame.}

\item{ae_data}{data.frame, of the AE variety}

\item{bds_data}{data.frame, of the BDS variety}
}
\value{
A `data.frame` object containing data of the AE variety if `x == "ADAE"` or one of the BDS variety if not.
}
\description{
Function to clean and combine ADAE dataset with ADSL
}
\examples{
if(interactive()) {
  datalist <- list(ADSL = tidyCDISC::adsl, ADVS = tidyCDISC::advs, 
                   ADAE = tidyCDISC::adae, ADLBC = tidyCDISC::adlbc)
                 
  pre_adsl <- prep_adsl(datalist$ADSL, input_recipe = 'NONE')
  pre_adae <- prep_adae(datalist, pre_adsl$data, 'NONE')
  ae_data <- pre_adae$data
  bds_data <- prep_bds(datalist, ADSL = pre_adsl$data)
  
  all.equal(data_to_use_str("ADAE", ae_data, bds_data), ae_data)
  all.equal(data_to_use_str("ADSL", ae_data, bds_data), bds_data)
}
}
\keyword{tabGen_repro}
