% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoji-summary.R
\name{emoji_tweets}
\alias{emoji_tweets}
\title{Emoji Text/Tweets Output}
\usage{
emoji_tweets(tweet_tbl, tweet_text)
}
\arguments{
\item{tweet_tbl}{A dataframe/tibble containing tweets/text.}

\item{tweet_text}{The tweet/text column.}
}
\value{
A dataframe/tibble containing only text with at least one Emoji
}
\description{
When users just want to focus on Tweets containing Emoji(s),
\code{emoji_tweets} filters out non-Emoji rows and only returns rows that
have at least one Emoji.
}
\examples{
library(dplyr)
data.frame(tweets = c("I love tidyverse \U0001f600\U0001f603\U0001f603",
                      "R is my language! \U0001f601\U0001f606\U0001f605",
                      "This Tweet does not have Emoji!",
                      "Wearing a mask\U0001f637\U0001f637\U0001f637.",
                      "Emoji does not appear in all Tweets",
                      "A flag \U0001f600\U0001f3c1")) \%>\%
         emoji_tweets(tweets)

}
