% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{heatmap}
\alias{heatmap}
\title{Creates a  `ComplexHeatmap` plot from `tbl_df`}
\usage{
heatmap(
  .data,
  .row,
  .column,
  .value,
  annotation = NULL,
  transform = NULL,
  palette_value = c("#440154FF", "#21908CFF", "#fefada"),
  palette_discrete = list(),
  palette_continuous = list(),
  .abundance = NULL,
  .horizontal = NULL,
  .vertical = NULL,
  log_transform = NULL,
  palette_abundance = NULL,
  ...
)
}
\arguments{
\item{.data}{A `tbl_df` formatted as | <ELEMENT> | <FEATURE> | <VALUE> | <...> |}

\item{.row}{The name of the column vertically presented in the heatmap}

\item{.column}{The name of the column horizontally presented in the heatmap}

\item{.value}{The name of the transcript/gene abundance column}

\item{annotation}{Vector of quotes}

\item{transform}{A function, used to tranform .value, for example log}

\item{palette_value}{A character vector This is the palette that will be used as gradient for .value}

\item{palette_discrete}{A list of character vectors. This is the list of palettes that will be used for horizontal and vertical discrete annotations. The discrete classification of annotations depends on the column type of your input tibble (e.g., character and factor).}

\item{palette_continuous}{A list of character vectors. This is the list of palettes that will be used for horizontal and vertical continuous annotations. The continuous classification of annotations depends on the column type of your input tibble (e.g., integer, numerical, double).}

\item{.abundance}{DEPRECATED. Please use .value instead}

\item{.horizontal}{DEPRECATED. Please use .column instead}

\item{.vertical}{DEPRECATED. Please use .row instead}

\item{log_transform}{DEPRECATED. Please use transform instead}

\item{palette_abundance}{DEPRECATED. Please use palette_value instead}

\item{...}{Further arguments to be passed to ComplexHeatmap::Heatmap}
}
\value{
A `ComplexHeatmap` object
}
\description{
heatmap() takes a tbl object and easily produces a ComplexHeatmap plot, with integration with tibble and dplyr frameworks.
}
\details{
\lifecycle{maturing}

To be added.
}
\examples{

library(dplyr)
tidyHeatmap::N52 \%>\%
group_by( `Cell type`) \%>\%
tidyHeatmap::heatmap(
 .row = symbol_ct,
 .column = UBR,
 .value = `read count normalised log`,
 annotation = CAPRA_TOTAL
)


}
