% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.R
\name{alpha_div}
\alias{alpha_div}
\title{Alpha Diversity Calculations for tidy_micro}
\usage{
alpha_div(micro_set, table = NULL, iter = 100, min_depth = 0, min_goods = 0)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{iter}{The number of bootstrap resamples used for estimation}

\item{min_depth}{Filter out libraries with sequencing depth (Total) below min_depth}

\item{min_goods}{Filter out libraries Good's coverage below min_goods}
}
\value{
A tidy_micro set with alpha diversity columns added in to the left of clinical data
}
\description{
A wrapper function to calculate Sobs, Choa1, Goods, Shannon's diversity and evenness, and Simpson's diversity and evenness alpha diversities for your micro_set. Estimates are calculated based on rarefied bootstrapped samples
}
\details{
If you have multiple otu tables, you can specify the table you'd like to use to calculate your alpha diversities using the \code{table} option. We highly recommend using the lowest taxonomic rank available to calculate your alpha diversity. If you would like to calculate alpha diversities for each otu table in your micro_set, you can leave the \code{table} option as \code{NULL} and the function will calculate the alpha diversity for each table. The function will append the estimated alpha diversities to the tidy_micro supplied. The alpha diversity columns will be just before your clinical data. Since alpha diversity is estimated for each individual library (Lib), it will be repeated within each taxa block.
}
\note{
Be aware of your minimal sequencing depth as this will be the size of all bootstrapped resamples (rarefied).
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)
otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
filter(day == 7) ## Only including the first week

\donttest{
## calculate alpha diversity for every table
set_alpha <- set \%>\% alpha_div(min_depth = 5000, min_goods = 90)

## calculate alpha diversity for a specific table
set_fam_alpha <- set \%>\% alpha_div(table = "Family", min_depth = 5000, min_goods = 90)
}
}
