% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_rocky_mtn.R
\name{cor_rocky_mtn}
\alias{cor_rocky_mtn}
\title{Create Rocky Mountain plots from taxa relative abundance correlations}
\usage{
cor_rocky_mtn(
  micro_set,
  table,
  x,
  y = clr,
  method = c("pearson", "kendall", "spearman"),
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  subtitle = NULL,
  cut_lines = TRUE,
  line_text = TRUE,
  sig_text = TRUE,
  lwd = 1,
  cor_label = 0.5,
  breaks = c(-0.6, -0.5, -0.3, 0.3, 0.5, 0.6)
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{x}{Continuous variable of interest}

\item{y}{The taxa information. The centered log ratio (clr) is recommended.}

\item{method}{Correlation type; must be supported by \code{\link[stats]{cor}}. By default it is "spearman" to use with clr. If you'd like to use taxa ra, it is recommend you switch to Kendall's correlation to account for the large number of ties common in taxa ra (lots of 0s)}

\item{main}{Plot title}

\item{xlab}{Lable for x-axis}

\item{ylab}{Label for y-axis}

\item{subtitle}{Plot subtitle}

\item{cut_lines}{Add lines for p-value cutoffs}

\item{line_text}{Label p-value cut-offs}

\item{sig_text}{Label taxa with correlations greater than \code{cor_label} in magnitude}

\item{lwd}{line width for cut_lines}

\item{cor_label}{Cutoff for correlations to be labeled}

\item{breaks}{Where to place cut_lines along y-axis}
}
\value{
A ggplot you can add geoms to if you'd like
}
\description{
Calculate the correlation between the relative abundance of each taxa within a specified table and a continuous variable of interest. Correlation is calculated by \code{\link[stats]{cor}}. By default, Kendall's correlation is used to account for the prevalence of ties that often occur (lots of 0s)
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)

otu_tabs <- list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

set \%>\% cor_rocky_mtn(table = "Family", weight, cor_label = 0.3)
}
\author{
Charlie Carpenter, Dan Frank
}
