% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_mods.R
\name{nb_mods}
\alias{nb_mods}
\title{Fit negative binomial models to each taxa within an OTU table}
\usage{
nb_mods(
  micro_set,
  table,
  ...,
  Offset = TRUE,
  ref = NULL,
  SS_type = c(2, 3, "II", "III")
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{...}{Covariates of interest. Can be interactions such as Group*Age}

\item{Offset}{Logical; include subject sequencing depth as an offset for negative binomial models. This is highly recommended}

\item{ref}{A character vector of the desired reference levels for each factor covariate. The order of the specifed references must match the order for the corresponding covariates specified in '...'}

\item{SS_type}{Type of sums of squares calculated in \code{\link[car]{Anova}}. Either type II (2) or type III (3) sums of squares}
}
\value{
A list containing several different model components and summaries
\item{Convergend_Summary}{A data.frame of model summaries from convergent models. Includes the Taxa name, the model coefficient, the estimated beta, the beta's 95 percent confidence interval, Z score, p_value, false discovery rate p-value, and p-value from likelihood ratio test}
\item{Estimate_Summary}{A data.frame of model estimates from convergent models intended to be ready for export for publications. Includes the Taxa name, the model coefficient, the estimated Rate Ratio, the Wald 95 percent confidence interval, the Z-score, and false discovery rate p-value}
\item{RA_Summary}{A data.frame of taxa summaries. Includes the Taxa name, grouping variables (each factor variable in your models), sample size (n), percent of 0 counts, basic summaries of relative abundance, percentiles of relative abundance, and a logical indicator of whether or not the model converged}
\item{formula}{The formula used in the model}
\item{Model_Coef}{Model coefficients (used in plotting funcitons)}
\item{Model_Covs}{Model covariates (used in plotting functions)}
}
\description{
Fit negative binomial models to each taxa within an OTU table through \code{\link[MASS]{glm.nb}} in the \pkg{MASS} package. Models can include a random effect if desired. Modesl will then be fit through \code{\link[lme4]{glmer.nb}} in the lmer package. Summaries for models or confidence intervals that fail to converge will not be returned, but taxa summaries will be provided in the output. Rank-Sum tests or presence/absence tests can be run on these taxa using \code{tidi_rank_sum} or \code{tidi_chisq}, respectively
}
\details{
Models containing only fixed effects are fit using \code{\link[MASS]{glm.nb}} in the \pkg{MASS} package and models containing random effects are fit using \code{\link[lme4]{glmer.nb}}. ANOVA / ANCOVA tests are conducted using a Likelihood Ratio test for fixed effects models and Chi-Squared tests for random effect models.
}
\note{
False Discovery Rate p-values are calculated using \code{\link[stats]{p.adjust}}. Estimated rate ratios and confidence intervals for interactions in the Estimate_Summary table include all main effects. It is not simply the exponentiated interaction beta, it is the interaction of the sum of the intercept, corresponding main effect betas, and interaction betas
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)
otu_tabs = list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7)

nb_fam <- set \%>\%
otu_filter(prev_cutoff = 5, ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
nb_mods(table = "Family", bpd1)

names(nb_fam)
nb_fam$Estimate_Summary
}
\references{
\code{\link[car]{Anova}}, \code{\link[MASS]{glm.nb}}, \code{\link[lme4]{glmer.nb}}
}
