% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_3d.R
\name{pca_3d}
\alias{pca_3d}
\title{Create 3d PCA plots}
\usage{
pca_3d(
  micro_set,
  table,
  time_var,
  subject,
  y = clr,
  dist_method = "euclidean",
  type = "PCoA",
  plot_scores = FALSE,
  pch = 16,
  cex.axis = 1,
  cex.lab = 1,
  cex = 1,
  main = NULL,
  subtitle = NULL,
  scalewt = TRUE,
  print.legend = TRUE,
  legend.title = "Time Points",
  legend.position = "right"
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{time_var}{The time point variable column name in your tidi_MIBI set}

\item{subject}{The subject variable column name in your tidi_MIBI set}

\item{y}{Value to calculate principle components or coordinates on. Default is centered log ratio (recommended)}

\item{dist_method}{Dissimilartiy method to be calculated by \code{\link[vegan]{vegdist}}. Euclidean by default}

\item{type}{"PCA" for principle components or "PCoA" to calculated dissimilarity matrix using \code{\link[vegan]{vegdist}}}

\item{plot_scores}{Plot the scores instead of the principle components}

\item{pch}{Plotting "character", i.e. symbol to use.}

\item{cex.axis}{Options for \code{\link[scatterplot3d]{scatterplot3d}}}

\item{cex.lab}{Options for \code{\link[scatterplot3d]{scatterplot3d}}}

\item{cex}{Options for \code{\link[scatterplot3d]{scatterplot3d}}}

\item{main}{Plot title}

\item{subtitle}{Plot subtitle}

\item{scalewt}{Logical; center and scale OTU table, recommended}

\item{print.legend}{Logical; print plot legend}

\item{legend.title}{Title for plot legend. Ignored if \code{print.legend = FALSE}}

\item{legend.position}{'x' argument in \code{\link[graphics]{legend}}}
}
\description{
Create three dimensional PCA plots from longitudinal data or multiple omics data sets.
}
\details{
Requires that you have separate columns for subject ID and time point. Data must be complete across time points. The function will automatically filter out incomplete cases with a warning message.

When type = "PCoA" the component matrices must be specified prior to the optimization. This is handled automatically.
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)
otu_tabs = list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin)

set \%>\% pca_3d(table = "Family", time_var = day, subject = study_id, legend.title = "Day")
}
\references{
\code{\link[vegan]{vegdist}}
}
\author{
Charlie Carpenter, Kayla Williamson
}
