% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_halfeyeh.R
\name{geom_halfeyeh}
\alias{geom_halfeyeh}
\title{Half-eye plots of densities with point and interval summaries (ggplot geom)}
\usage{
geom_halfeyeh(mapping = NULL, data = NULL, position = "identity",
  trim = TRUE, scale = "area", relative_scale = 1, fill = NULL,
  density.color = NA, ..., point_interval = median_qi,
  fun.data = NULL, fun.args = list(), .width = c(0.66, 0.95), .prob,
  color = NULL, size = NULL, size_domain = NULL, size_range = NULL,
  fatten_point = NULL)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set at the
layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{position}{The position adjustment
to use for overlapping points on this layer.}

\item{trim}{If \code{TRUE} (default),
trim the tails of the density to the range of the data. If \code{FALSE},
don't trim the tails.}

\item{scale}{If "area" (default), all
densities have the same area (before trimming the tails).  If "count", areas
are scaled proportionally to the number of observations. If "width", all
densities have the same maximum width/height.}

\item{relative_scale}{A relative scaling factor to determine how much of the available
space densities are scaled to fill: if \code{1}, all available space is filled.}

\item{fill}{Fill color of the density.}

\item{density.color}{Outline color of the density.
The default, \code{NA}, suppresses the density outline. Set to another value to set the density outline color
manually, or set to \code{NULL} if you want the outline color of the density to be determined by the aesthetic
mapping.}

\item{...}{Currently unused.}

\item{point_interval}{A function that when given a vector should
return a data frame with variables \code{y}, \code{ymin}, \code{ymax}, and \code{.width}; or
\code{x}, \code{xmin}, \code{xmax}, and \code{.width}. \strong{Either is acceptable}: output
will be converted into the \code{x}-based aesthetics \code{geom_halfeyeh}.
See the \code{point_interval} family of functions.}

\item{fun.data}{Similar to \code{point_interval}, for compatibility with \code{stat_summary}.
Note: if the summary function is passed using \code{fun.data}, the \code{x} and \code{y}-based aesthetics
are not converted to the correct form automatically.}

\item{fun.args}{Optional arguments passed to \code{fun.data}.}

\item{.width}{The \code{.width} argument passed to \code{point_interval}.}

\item{.prob}{Deprecated. Use \code{.width} instead.}

\item{color}{Passed to \code{\link{stat_pointintervalh}}. Color of the point
summary and uncertainty interval.}

\item{size}{Passed to \code{\link{stat_pointintervalh}}. Line weight of the point
summary and uncertainty interval.}

\item{size_domain}{The minimum and maximum of the values of the size aesthetic that will be translated into actual
sizes drawn according to \code{size_range} (see the documentation for that argument, below.)}

\item{size_range}{This geom scales the raw size aesthetic values, as they tend to be too thick when using the default
settings of \code{\link{scale_size_continuous}}, which give sizes with a range of \code{c(1, 6)}. The
\code{size_domain} value indicates the input domain of raw size values (typically this should be equal to the value
of the \code{range} argument of the \code{\link{scale_size_continuous}} function), and \code{size_range} indicates
the desired output range of the size values (the min and max of the actual sizes used to draw intervals).}

\item{fatten_point}{A multiplicative factor used to adjust the size of the point relative to the size of the
thickest line.}
}
\description{
Generates a combination of a density and \code{\link{stat_pointintervalh}}
representing the density, point summary, and uncertainty intervals
for draws from a distribution. Useful for representing posteriors from Bayesian models;
in that context the mirrored version is variously called an eye plot, a raindrop plot,
violin plot; hence "half-eye" for this plot.
}
\details{
A half-eye plot is a compact visual summary of the distribution of a sample,
used (under various names and with subtle variations) to visualize posterior
distributions in Bayesian inference. This instantiation is a combination of
a density plot, point summary, and one or more uncertainty intervals.

\code{geom_halfeyeh()} is roughly equivalent to \code{geom_density_ridges() + stat_pointintervalh()}
with some reasonable defaults, including color choices and the use of median with 95\%
and 66\% quantile intervals.
}
\examples{

library(magrittr)
library(ggplot2)

data(RankCorr, package = "tidybayes")

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  ggplot(aes(y = i, x = u_tau)) +
  geom_halfeyeh()

}
\seealso{
See \code{\link{geom_eye}} and \code{\link{geom_eyeh}} for the mirrored-density
(full "eye") versions. See \code{\link{geom_density_ridges}} and \code{\link{stat_summaryh}} for the geoms
this function is based on.
}
\author{
Matthew Kay
}
\keyword{manip}
